/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.hubspot.jinjava.interpret.TagCycleException;
import java.util.Optional;
import java.util.Stack;

public class CallStack {
    private final CallStack parent;
    private final Class<? extends TagCycleException> exceptionClass;
    private final Stack<String> stack = new Stack();
    private final int depth;
    private int topLineNumber = -1;
    private int topStartPosition = -1;

    public CallStack(CallStack parent, Class<? extends TagCycleException> exceptionClass) {
        this.parent = parent;
        this.exceptionClass = exceptionClass;
        this.depth = parent == null ? 0 : parent.depth + 1;
    }

    public boolean contains(String path) {
        if (this.stack.contains(path)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.contains(path);
        }
        return false;
    }

    public void pushWithoutCycleCheck(String path, int lineNumber, int startPosition) {
        this.pushToStack(path, lineNumber, startPosition);
    }

    public void pushWithMaxDepth(String path, int maxDepth, int lineNumber, int startPosition) {
        if (this.depth >= maxDepth) {
            throw TagCycleException.create(this.exceptionClass, path, Optional.of(lineNumber), Optional.of(startPosition));
        }
        this.pushToStack(path, lineNumber, startPosition);
    }

    public void push(String path, int lineNumber, int startPosition) {
        if (this.contains(path)) {
            throw TagCycleException.create(this.exceptionClass, path, Optional.of(lineNumber), Optional.of(startPosition));
        }
        this.pushToStack(path, lineNumber, startPosition);
    }

    public Optional<String> pop() {
        if (this.stack.isEmpty()) {
            if (this.parent != null) {
                return this.parent.pop();
            }
            return Optional.empty();
        }
        return Optional.of(this.stack.pop());
    }

    public Optional<String> peek() {
        if (this.stack.isEmpty()) {
            if (this.parent != null) {
                return this.parent.peek();
            }
            return Optional.empty();
        }
        return Optional.of(this.stack.peek());
    }

    public int getTopLineNumber() {
        if (this.topLineNumber == -1 && this.parent != null) {
            return this.parent.getTopLineNumber();
        }
        return this.topLineNumber;
    }

    public int getTopStartPosition() {
        if (this.topStartPosition == -1 && this.parent != null) {
            return this.parent.getTopStartPosition();
        }
        return this.topStartPosition;
    }

    public boolean isEmpty() {
        return this.stack.empty() && (this.parent == null || this.parent.isEmpty());
    }

    private void pushToStack(String path, int lineNumber, int startPosition) {
        if (this.isEmpty()) {
            this.topLineNumber = lineNumber;
            this.topStartPosition = startPosition;
        }
        this.stack.push(path);
    }
}

