/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.user;

import java.io.IOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Base64;

public class Encryptor {
    private final BufferedBlockCipher encryptCipher = new PaddedBufferedBlockCipher((BlockCipher)new AESEngine(), (BlockCipherPadding)new ZeroBytePadding());
    private final BufferedBlockCipher decryptCipher;

    public Encryptor(String encryptKey) {
        this.encryptCipher.init(true, (CipherParameters)new KeyParameter(encryptKey.getBytes()));
        this.decryptCipher = new PaddedBufferedBlockCipher((BlockCipher)new AESEngine(), (BlockCipherPadding)new ZeroBytePadding());
        this.decryptCipher.init(false, (CipherParameters)new KeyParameter(encryptKey.getBytes()));
    }

    public String encrypt(String inputString) throws IOException {
        byte[] input = inputString.getBytes();
        byte[] result = new byte[this.encryptCipher.getOutputSize(input.length)];
        int size = this.encryptCipher.processBytes(input, 0, input.length, result, 0);
        try {
            size += this.encryptCipher.doFinal(result, size);
            byte[] out = new byte[size];
            System.arraycopy(result, 0, out, 0, size);
            return new String(Base64.encode((byte[])out));
        }
        catch (InvalidCipherTextException e) {
            throw new IOException("Cannot encrypt: " + e.getMessage(), e);
        }
    }

    public String decrypt(String base64Input) throws IOException {
        byte[] input = Base64.decode((String)base64Input);
        byte[] result = new byte[this.decryptCipher.getOutputSize(input.length)];
        int size = this.decryptCipher.processBytes(input, 0, input.length, result, 0);
        try {
            size += this.decryptCipher.doFinal(result, size);
            byte[] out = new byte[size];
            System.arraycopy(result, 0, out, 0, size);
            return new String(out);
        }
        catch (InvalidCipherTextException e) {
            throw new IOException("Cannot decrypt: " + e.getMessage(), e);
        }
    }
}

