/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.user.AuthenticationInfo;

public class InMemoryNotebookRepo
implements NotebookRepo {
    private Map<String, Note> notes = new HashMap<String, Note>();

    @Override
    public void init(ZeppelinConfiguration zConf) throws IOException {
    }

    @Override
    public Map<String, NoteInfo> list(AuthenticationInfo subject) throws IOException {
        HashMap<String, NoteInfo> notesInfo = new HashMap<String, NoteInfo>();
        for (Note note : this.notes.values()) {
            notesInfo.put(note.getId(), new NoteInfo(note));
        }
        return notesInfo;
    }

    @Override
    public Note get(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        if (!notePath.startsWith("/")) {
            throw new RuntimeException(String.format("notePath '%s' is not started with '/'", notePath));
        }
        return this.notes.get(noteId);
    }

    @Override
    public void save(Note note, AuthenticationInfo subject) throws IOException {
        this.notes.put(note.getId(), note);
    }

    @Override
    public void move(String noteId, String notePath, String newNotePath, AuthenticationInfo subject) {
        if (!newNotePath.startsWith("/")) {
            throw new RuntimeException(String.format("newNotePath '%s' is not started with '/'", newNotePath));
        }
        if (newNotePath.startsWith("//")) {
            throw new RuntimeException(String.format("newNotePath '%s' is started with '//'", newNotePath));
        }
    }

    @Override
    public void move(String folderPath, String newFolderPath, AuthenticationInfo subject) {
        if (!folderPath.startsWith("/")) {
            throw new RuntimeException(String.format("folderPath '%s' is not started with '/'", folderPath));
        }
        if (folderPath.startsWith("//")) {
            throw new RuntimeException(String.format("folderPath '%s' is started with '//'", folderPath));
        }
        if (!newFolderPath.startsWith("/")) {
            throw new RuntimeException(String.format("newFolderPath '%s' is not started with '/'", newFolderPath));
        }
        if (newFolderPath.startsWith("//")) {
            throw new RuntimeException(String.format("newFolderPath '%s' is started with '//'", newFolderPath));
        }
    }

    @Override
    public void remove(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        if (!notePath.startsWith("/")) {
            throw new RuntimeException(String.format("notePath '%s' is not started with '/'", notePath));
        }
        this.notes.remove(noteId);
    }

    @Override
    public void remove(String folderPath, AuthenticationInfo subject) {
        if (!folderPath.startsWith("/")) {
            throw new RuntimeException(String.format("folderPath '%s' is not started with '/'", folderPath));
        }
    }

    @Override
    public void close() {
    }

    @Override
    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        return Collections.emptyList();
    }

    @Override
    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
    }

    public void reset() {
        this.notes.clear();
    }
}

