/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.user.AuthenticationInfo;

public class NoteAuth {
    private final String noteId;
    private final ZeppelinConfiguration zconf;
    private Set<String> readers = new HashSet<String>();
    private Set<String> writers = new HashSet<String>();
    private Set<String> runners = new HashSet<String>();
    private Set<String> owners = new HashSet<String>();

    public NoteAuth(String noteId, ZeppelinConfiguration zconf) {
        this(noteId, AuthenticationInfo.ANONYMOUS, zconf);
    }

    public NoteAuth(String noteId, AuthenticationInfo subject, ZeppelinConfiguration zconf) {
        this.noteId = noteId;
        this.zconf = zconf;
        this.initPermissions(subject);
    }

    public NoteAuth(String noteId, Map<String, Set<String>> permissions, ZeppelinConfiguration zconf) {
        this.noteId = noteId;
        this.zconf = zconf;
        this.readers = permissions.getOrDefault("readers", new HashSet());
        this.writers = permissions.getOrDefault("writers", new HashSet());
        this.runners = permissions.getOrDefault("runners", new HashSet());
        this.owners = permissions.getOrDefault("owners", new HashSet());
    }

    public void initPermissions(AuthenticationInfo subject) {
        if (!AuthenticationInfo.isAnonymous((AuthenticationInfo)subject)) {
            if (this.zconf.isNotebookPublic()) {
                this.owners.add(this.checkCaseAndConvert(subject.getUser()));
            } else {
                this.owners.add(this.checkCaseAndConvert(subject.getUser()));
                this.readers.add(this.checkCaseAndConvert(subject.getUser()));
                this.writers.add(this.checkCaseAndConvert(subject.getUser()));
                this.runners.add(this.checkCaseAndConvert(subject.getUser()));
            }
        }
    }

    public String getNoteId() {
        return this.noteId;
    }

    public void setOwners(Set<String> entities) {
        this.owners = this.checkCaseAndConvert(entities);
    }

    public void setReaders(Set<String> entities) {
        this.readers = this.checkCaseAndConvert(entities);
    }

    public void setWriters(Set<String> entities) {
        this.writers = this.checkCaseAndConvert(entities);
    }

    public void setRunners(Set<String> entities) {
        this.runners = this.checkCaseAndConvert(entities);
    }

    public Set<String> getOwners() {
        return this.owners;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public Set<String> getWriters() {
        return this.writers;
    }

    public Set<String> getRunners() {
        return this.runners;
    }

    private Set<String> checkCaseAndConvert(Set<String> entities) {
        if (this.zconf.isUsernameForceLowerCase()) {
            HashSet<String> set2 = new HashSet<String>();
            for (String name : entities) {
                set2.add(name.toLowerCase());
            }
            return set2;
        }
        return entities;
    }

    private String checkCaseAndConvert(String entity) {
        if (this.zconf.isUsernameForceLowerCase()) {
            return entity.toLowerCase();
        }
        return entity;
    }

    public Map<String, Set<String>> toMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("readers", this.readers);
        map.put("writers", this.writers);
        map.put("runners", this.runners);
        map.put("owners", this.owners);
        return map;
    }
}

