/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.remote.PooledRemoteClient;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteInterpreterProcess
implements InterpreterClient,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterProcess.class);
    private static final Gson GSON = new Gson();
    private int connectTimeout;
    protected String intpEventServerHost;
    protected int intpEventServerPort;
    private PooledRemoteClient<RemoteInterpreterService.Client> remoteClient;
    private String startTime;

    public RemoteInterpreterProcess(int connectTimeout, int connectionPoolSize, String intpEventServerHost, int intpEventServerPort) {
        this.connectTimeout = connectTimeout;
        this.intpEventServerHost = intpEventServerHost;
        this.intpEventServerPort = intpEventServerPort;
        this.startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        this.remoteClient = new PooledRemoteClient(() -> {
            TSocket transport = new TSocket(this.getHost(), this.getPort());
            try {
                transport.open();
            }
            catch (TTransportException e) {
                throw new IOException(e);
            }
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            return new RemoteInterpreterService.Client((TProtocol)protocol);
        }, connectionPoolSize);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public void close() {
        if (this.remoteClient != null) {
            this.remoteClient.close();
            this.remoteClient = null;
        }
    }

    public void updateRemoteAngularObject(String name, String noteId, String paragraphId, Object o) {
        this.remoteClient.callRemoteFunction(client -> {
            client.angularObjectUpdate(name, noteId, paragraphId, GSON.toJson(o));
            return null;
        });
    }

    public <R> R callRemoteFunction(PooledRemoteClient.RemoteFunction<R, RemoteInterpreterService.Client> func) {
        return (R)this.remoteClient.callRemoteFunction(func);
    }

    public void init(ZeppelinConfiguration zConf) {
        this.callRemoteFunction(client -> {
            client.init(zConf.getCompleteConfiguration());
            return null;
        });
    }

    public boolean recover() {
        try {
            this.remoteClient.callRemoteFunction(client -> {
                client.reconnect(this.intpEventServerHost, this.intpEventServerPort);
                return null;
            });
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Fail to recover remote interpreter process: {}", (Object)e.getMessage());
            return false;
        }
    }

    public abstract void processStarted(int var1, String var2);

    public abstract String getErrorMessage();
}

