/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterManagedProcess;
import org.apache.zeppelin.scheduler.SchedulerThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnAppMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnAppMonitor.class);
    private static YarnAppMonitor instance;
    private ZeppelinConfiguration conf;
    private ScheduledExecutorService executor;
    private YarnClient yarnClient;
    private ConcurrentHashMap<ApplicationId, RemoteInterpreterManagedProcess> apps;

    public static synchronized YarnAppMonitor get() {
        if (instance == null) {
            instance = new YarnAppMonitor();
        }
        return instance;
    }

    private YarnAppMonitor() {
        try {
            this.conf = ZeppelinConfiguration.create();
            this.yarnClient = YarnClient.createYarnClient();
            YarnConfiguration yarnConf = new YarnConfiguration();
            yarnConf.set("yarn.timeline-service.enabled", "false");
            this.yarnClient.init((Configuration)yarnConf);
            this.yarnClient.start();
            this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new SchedulerThreadFactory("YarnAppsMonitor-Thread"));
            this.apps = new ConcurrentHashMap();
            this.executor.scheduleAtFixedRate(() -> {
                try {
                    Iterator<Map.Entry<ApplicationId, RemoteInterpreterManagedProcess>> iter = this.apps.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<ApplicationId, RemoteInterpreterManagedProcess> entry = iter.next();
                        ApplicationId appId = entry.getKey();
                        RemoteInterpreterManagedProcess interpreterManagedProcess = entry.getValue();
                        ApplicationReport appReport = this.yarnClient.getApplicationReport(appId);
                        if (appReport.getYarnApplicationState() == YarnApplicationState.FAILED || appReport.getYarnApplicationState() == YarnApplicationState.KILLED) {
                            String yarnDiagnostics = appReport.getDiagnostics();
                            interpreterManagedProcess.processStopped("Yarn diagnostics: " + yarnDiagnostics);
                            iter.remove();
                            LOGGER.info("Remove {} from YarnAppMonitor, because its state is {}", (Object)appId, (Object)appReport.getYarnApplicationState());
                            continue;
                        }
                        if (appReport.getYarnApplicationState() != YarnApplicationState.FINISHED) continue;
                        iter.remove();
                        LOGGER.info("Remove {} from YarnAppMonitor, because its state is {}", (Object)appId, (Object)appReport.getYarnApplicationState());
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Fail to check yarn app status", (Throwable)e);
                }
            }, this.conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_YARN_MONITOR_INTERVAL_SECS), this.conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_YARN_MONITOR_INTERVAL_SECS), TimeUnit.SECONDS);
            LOGGER.info("YarnAppMonitor is started");
        }
        catch (Throwable e) {
            LOGGER.warn("Fail to initialize YarnAppMonitor", e);
        }
    }

    public void addYarnApp(ApplicationId appId, RemoteInterpreterManagedProcess interpreterManagedProcess) {
        LOGGER.info("Add {} to YarnAppMonitor", (Object)appId);
        this.apps.put(appId, interpreterManagedProcess);
    }
}

