/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.service;

import com.google.common.base.Preconditions;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.service.Commit;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.time.WallClockTimestamp;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ServiceExecutor
extends Executor,
Scheduler {
    public void tick(WallClockTimestamp var1);

    public byte[] apply(Commit<byte[]> var1);

    public void handle(OperationId var1, Function<Commit<byte[]>, byte[]> var2);

    default public void register(OperationId operationId, Runnable callback) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull((Object)callback, (Object)"callback cannot be null");
        this.handle(operationId, commit -> {
            callback.run();
            return null;
        });
    }

    public <R> void register(OperationId var1, Supplier<R> var2);

    public <T> void register(OperationId var1, Consumer<Commit<T>> var2);

    public <T, R> void register(OperationId var1, Function<Commit<T>, R> var2);
}

