/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy;

import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.proxy.ProxySession;
import io.atomix.utils.concurrent.Futures;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public interface ProxyClient<S> {
    public String name();

    public PrimitiveType type();

    public PrimitiveProtocol protocol();

    public PrimitiveState getState();

    public Collection<ProxySession<S>> getPartitions();

    public Collection<PartitionId> getPartitionIds();

    public ProxySession<S> getPartition(PartitionId var1);

    public PartitionId getPartitionId(String var1);

    public PartitionId getPartitionId(Object var1);

    default public ProxySession<S> getPartition(String key) {
        return this.getPartition(this.getPartitionId(key));
    }

    default public ProxySession<S> getPartition(Object key) {
        return this.getPartition(this.getPartitionId(key));
    }

    default public void register(Object client) {
        this.getPartitions().forEach(partition -> partition.register(client));
    }

    default public CompletableFuture<Void> acceptAll(Consumer<S> operation) {
        return Futures.allOf(this.getPartitions().stream().map(proxy -> proxy.accept(operation))).thenApply(v -> null);
    }

    default public <R> CompletableFuture<Stream<R>> applyAll(Function<S, R> operation) {
        return Futures.allOf(this.getPartitions().stream().map(proxy -> proxy.apply(operation)));
    }

    default public CompletableFuture<Void> acceptOn(PartitionId partitionId, Consumer<S> operation) {
        return this.getPartition(partitionId).accept(operation);
    }

    default public <R> CompletableFuture<R> applyOn(PartitionId partitionId, Function<S, R> operation) {
        return this.getPartition(partitionId).apply(operation);
    }

    default public CompletableFuture<Void> acceptBy(String key, Consumer<S> operation) {
        return this.getPartition(key).accept(operation);
    }

    default public <R> CompletableFuture<R> applyBy(String key, Function<S, R> operation) {
        return this.getPartition(key).apply(operation);
    }

    default public <R> CompletableFuture<R> applyBy(Object key, Function<S, R> operation) {
        return this.getPartition(key).apply(operation);
    }

    public void addStateChangeListener(Consumer<PrimitiveState> var1);

    public void removeStateChangeListener(Consumer<PrimitiveState> var1);

    public CompletableFuture<ProxyClient<S>> connect();

    public CompletableFuture<Void> close();
}

