/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.config.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.atomix.primitive.config.ConfigService;
import io.atomix.primitive.config.PrimitiveConfig;
import java.util.Collection;
import java.util.Map;

public class DefaultConfigService
implements ConfigService {
    private final Map<String, PrimitiveConfig> configs = Maps.newConcurrentMap();

    public DefaultConfigService(Collection<PrimitiveConfig> configs) {
        configs.forEach(config -> this.configs.put(config.getName(), (PrimitiveConfig)config));
    }

    @Override
    public <C extends PrimitiveConfig<C>> C getConfig(String primitiveName) {
        return (C)this.configs.get(primitiveName);
    }

    @Override
    public PrimitiveConfig addConfig(PrimitiveConfig config) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        PrimitiveConfig previous = this.configs.putIfAbsent(config.getName(), config);
        return previous != null ? previous : config;
    }
}

