/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.service.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionListener;
import io.atomix.primitive.session.Sessions;
import io.atomix.protocols.backup.impl.PrimaryBackupSession;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PrimaryBackupServiceSessions
implements Sessions {
    private final Map<Long, PrimaryBackupSession> sessions = Maps.newConcurrentMap();
    private final Set<SessionListener> listeners = Sets.newIdentityHashSet();

    public void openSession(PrimaryBackupSession session) {
        this.sessions.put((Long)session.sessionId().id(), session);
        this.listeners.forEach(l -> l.onOpen((Session)session));
    }

    public void expireSession(PrimaryBackupSession session) {
        if (this.sessions.remove(session.sessionId().id()) != null) {
            session.expire();
            this.listeners.forEach(l -> l.onExpire((Session)session));
        }
    }

    public void closeSession(PrimaryBackupSession session) {
        if (this.sessions.remove(session.sessionId().id()) != null) {
            session.close();
            this.listeners.forEach(l -> l.onClose((Session)session));
        }
    }

    public PrimaryBackupSession getSession(long sessionId) {
        return this.sessions.get(sessionId);
    }

    public Sessions addListener(SessionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public Sessions removeListener(SessionListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public Iterator<Session> iterator() {
        return this.sessions.values().iterator();
    }
}

