/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition.impl;

import io.atomix.primitive.partition.MemberGroupProvider;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.partition.PrimaryBackupPartition;
import io.atomix.protocols.backup.partition.impl.PrimaryBackupServerCommunicator;
import io.atomix.protocols.backup.serializer.impl.PrimaryBackupNamespaces;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryBackupPartitionServer
implements Managed<PrimaryBackupPartitionServer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PrimaryBackupPartition partition;
    private final PartitionManagementService managementService;
    private final MemberGroupProvider memberGroupProvider;
    private final ThreadContextFactory threadFactory;
    private PrimaryBackupServer server;
    private final AtomicBoolean started = new AtomicBoolean();

    public PrimaryBackupPartitionServer(PrimaryBackupPartition partition, PartitionManagementService managementService, MemberGroupProvider memberGroupProvider, ThreadContextFactory threadFactory) {
        this.partition = partition;
        this.managementService = managementService;
        this.memberGroupProvider = memberGroupProvider;
        this.threadFactory = threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<PrimaryBackupPartitionServer> start() {
        PrimaryBackupPartitionServer primaryBackupPartitionServer = this;
        synchronized (primaryBackupPartitionServer) {
            this.server = this.buildServer();
        }
        return this.server.start().thenApply(s -> {
            this.log.debug("Successfully started server for {}", (Object)this.partition.id());
            this.started.set(true);
            return this;
        });
    }

    public boolean isRunning() {
        return this.started.get();
    }

    private PrimaryBackupServer buildServer() {
        return PrimaryBackupServer.builder().withServerName(this.partition.name()).withMembershipService(this.managementService.getMembershipService()).withMemberGroupProvider(this.memberGroupProvider).withProtocol(new PrimaryBackupServerCommunicator(this.partition.name(), Serializer.using((Namespace)PrimaryBackupNamespaces.PROTOCOL), this.managementService.getMessagingService())).withPrimaryElection(this.managementService.getElectionService().getElectionFor(this.partition.id())).withPrimitiveTypes(this.managementService.getPrimitiveTypes()).withThreadContextFactory(this.threadFactory).build();
    }

    public CompletableFuture<Void> stop() {
        PrimaryBackupServer server = this.server;
        if (server != null) {
            return ((CompletableFuture)server.stop().exceptionally(throwable -> {
                this.log.error("Failed stopping server for {}", (Object)this.partition.id(), throwable);
                return null;
            })).thenRun(() -> this.started.set(false));
        }
        this.started.set(false);
        return CompletableFuture.completedFuture(null);
    }
}

