/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.impl;

import com.google.common.collect.Maps;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.primitive.PrimitiveId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.primitive.partition.GroupMember;
import io.atomix.primitive.partition.ManagedMemberGroupService;
import io.atomix.primitive.partition.MemberGroup;
import io.atomix.primitive.partition.MemberGroupService;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.protocol.BackupRequest;
import io.atomix.protocols.backup.protocol.BackupResponse;
import io.atomix.protocols.backup.protocol.CloseRequest;
import io.atomix.protocols.backup.protocol.CloseResponse;
import io.atomix.protocols.backup.protocol.ExecuteRequest;
import io.atomix.protocols.backup.protocol.ExecuteResponse;
import io.atomix.protocols.backup.protocol.MetadataRequest;
import io.atomix.protocols.backup.protocol.MetadataResponse;
import io.atomix.protocols.backup.protocol.PrimaryBackupServerProtocol;
import io.atomix.protocols.backup.protocol.PrimitiveRequest;
import io.atomix.protocols.backup.protocol.RestoreRequest;
import io.atomix.protocols.backup.protocol.RestoreResponse;
import io.atomix.protocols.backup.service.impl.PrimaryBackupServiceContext;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.OrderedFuture;
import io.atomix.utils.concurrent.ThreadContextFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryBackupServerContext
implements Managed<Void> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String serverName;
    private final ClusterMembershipService clusterMembershipService;
    private final ManagedMemberGroupService memberGroupService;
    private final PrimaryBackupServerProtocol protocol;
    private final ThreadContextFactory threadContextFactory;
    private final boolean closeOnStop;
    private final PrimitiveTypeRegistry primitiveTypes;
    private final PrimaryElection primaryElection;
    private final Map<String, CompletableFuture<PrimaryBackupServiceContext>> services = Maps.newConcurrentMap();
    private final AtomicBoolean started = new AtomicBoolean();

    public PrimaryBackupServerContext(String serverName, ClusterMembershipService clusterMembershipService, ManagedMemberGroupService memberGroupService, PrimaryBackupServerProtocol protocol, PrimitiveTypeRegistry primitiveTypes, PrimaryElection primaryElection, ThreadContextFactory threadContextFactory, boolean closeOnStop) {
        this.serverName = serverName;
        this.clusterMembershipService = clusterMembershipService;
        this.memberGroupService = memberGroupService;
        this.protocol = protocol;
        this.threadContextFactory = threadContextFactory;
        this.closeOnStop = closeOnStop;
        this.primitiveTypes = primitiveTypes;
        this.primaryElection = primaryElection;
    }

    public PrimaryBackupServer.Role getRole() {
        return Objects.equals(((PrimaryTerm)Futures.get((Future)this.primaryElection.getTerm())).primary().memberId(), this.clusterMembershipService.getLocalMember().id()) ? PrimaryBackupServer.Role.PRIMARY : PrimaryBackupServer.Role.BACKUP;
    }

    public CompletableFuture<Void> start() {
        this.registerListeners();
        return ((CompletableFuture)this.memberGroupService.start().thenCompose(v -> {
            MemberGroup group = this.memberGroupService.getMemberGroup(this.clusterMembershipService.getLocalMember());
            if (group != null) {
                return this.primaryElection.enter(new GroupMember(this.clusterMembershipService.getLocalMember().id(), group.id()));
            }
            return CompletableFuture.completedFuture(null);
        })).thenApply(v -> {
            this.started.set(true);
            return null;
        });
    }

    private CompletableFuture<ExecuteResponse> execute(ExecuteRequest request) {
        return this.getService(request).thenCompose(service -> service.execute(request));
    }

    private CompletableFuture<BackupResponse> backup(BackupRequest request) {
        return this.getService(request).thenCompose(service -> service.backup(request));
    }

    private CompletableFuture<RestoreResponse> restore(RestoreRequest request) {
        return this.getService(request).thenCompose(service -> service.restore(request));
    }

    private CompletableFuture<CloseResponse> close(CloseRequest request) {
        return this.getService(request).thenCompose(service -> service.close(request));
    }

    private CompletableFuture<PrimaryBackupServiceContext> getService(PrimitiveRequest request) {
        return this.services.computeIfAbsent(request.primitive().name(), n -> {
            PrimitiveType primitiveType = this.primitiveTypes.getPrimitiveType(request.primitive().type());
            PrimaryBackupServiceContext service = new PrimaryBackupServiceContext(this.serverName, PrimitiveId.from((String)request.primitive().name()), primitiveType, request.primitive(), this.threadContextFactory.createContext(), this.clusterMembershipService, (MemberGroupService)this.memberGroupService, this.protocol, this.primaryElection);
            OrderedFuture newOrderFuture = new OrderedFuture();
            service.open().whenComplete((v, e) -> {
                if (e != null) {
                    newOrderFuture.completeExceptionally(e);
                } else {
                    newOrderFuture.complete((Object)service);
                }
            });
            return newOrderFuture;
        });
    }

    private CompletableFuture<MetadataResponse> metadata(MetadataRequest request) {
        return CompletableFuture.completedFuture(MetadataResponse.ok(this.services.entrySet().stream().filter(entry -> ((PrimaryBackupServiceContext)Futures.get((Future)((Future)entry.getValue()))).serviceType().name().equals(request.primitiveType())).map(entry -> (String)entry.getKey()).collect(Collectors.toSet())));
    }

    private void registerListeners() {
        this.protocol.registerExecuteHandler(this::execute);
        this.protocol.registerBackupHandler(this::backup);
        this.protocol.registerRestoreHandler(this::restore);
        this.protocol.registerCloseHandler(this::close);
        this.protocol.registerMetadataHandler(this::metadata);
    }

    private void unregisterListeners() {
        this.protocol.unregisterExecuteHandler();
        this.protocol.unregisterBackupHandler();
        this.protocol.unregisterRestoreHandler();
        this.protocol.unregisterCloseHandler();
        this.protocol.unregisterMetadataHandler();
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        this.unregisterListeners();
        this.started.set(false);
        List futures = this.services.values().stream().map(future -> future.thenCompose(service -> service.close())).collect(Collectors.toList());
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)Futures.allOf(futures).exceptionally(throwable -> {
            this.log.error("Failed closing services", throwable);
            return null;
        })).thenCompose(v -> this.memberGroupService.stop())).exceptionally(throwable -> {
            this.log.error("Failed stopping member group service", throwable);
            return null;
        })).thenRunAsync(() -> {
            if (this.closeOnStop) {
                this.threadContextFactory.close();
            }
        });
    }
}

