/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.markdown;

import com.vladsch.flexmark.ext.gitlab.internal.GitLabOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.markdown.UMLBlockQuote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMLBlockQuoteParser
extends AbstractBlockParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(UMLBlockQuoteParser.class);
    private static final Pattern YUML_BLOCK_START = Pattern.compile("(%%%)\\s+(.*\\n)");
    private static final Pattern YUML_BLOCK_END = Pattern.compile("%%%(\\s*$)");
    private final UMLBlockQuote block = new UMLBlockQuote();
    private BlockContent content = new BlockContent();
    private final GitLabOptions options;
    private boolean hadClose = false;

    UMLBlockQuoteParser(DataHolder options, BasedSequence openMarker, BasedSequence openTrailing) {
        this.options = new GitLabOptions(options);
        this.block.setOpeningMarker(openMarker);
        this.block.setOpeningTrailing(openTrailing);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        BlockParser parser;
        if (this.hadClose) {
            return BlockContinue.none();
        }
        int index = state.getIndex();
        BasedSequence line = state.getLineWithEOL();
        Matcher matcher = YUML_BLOCK_END.matcher((CharSequence)line.subSequence(index));
        if (!matcher.matches()) {
            return BlockContinue.atIndex(index);
        }
        Node lastChild = this.block.getLastChild();
        if (lastChild instanceof UMLBlockQuote && (parser = state.getActiveBlockParser((Block)lastChild)) instanceof UMLBlockQuoteParser && !((UMLBlockQuoteParser)parser).hadClose) {
            return BlockContinue.atIndex(index);
        }
        this.hadClose = true;
        this.block.setClosingMarker(state.getLine().subSequence(index, index + 3));
        this.block.setClosingTrailing(state.getLineWithEOL().subSequence(matcher.start(1), matcher.end(1)));
        return BlockContinue.atIndex(state.getLineEndIndex());
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setContent(this.content);
        this.block.setCharsFromContent();
        this.content = null;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final GitLabOptions options;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new GitLabOptions(options);
        }

        boolean haveBlockQuoteParser(ParserState state) {
            List<BlockParser> parsers = state.getActiveBlockParsers();
            int i = parsers.size();
            while (i-- > 0) {
                if (!(parsers.get(i) instanceof UMLBlockQuoteParser)) continue;
                return true;
            }
            return false;
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (this.options.nestedBlockQuotes || !this.haveBlockQuoteParser(state)) {
                BasedSequence line = state.getLineWithEOL();
                Matcher matcher = YUML_BLOCK_START.matcher(line);
                if (matcher.matches()) {
                    LOGGER.debug("Matcher group count {} ", (Object)matcher.groupCount());
                    return BlockStart.of(new UMLBlockQuoteParser(state.getProperties(), line.subSequence(0, 3), line.subSequence(4, line.length()))).atIndex(state.getLineEndIndex());
                }
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        public BlockParserFactory apply(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

