/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.util.Messages;

public class FileSystemException
extends IOException {
    private static final long serialVersionUID = 20101208L;
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");
    private final String[] info;

    public static <T> T requireNonNull(T obj, String code) throws FileSystemException {
        if (obj == null) {
            throw new FileSystemException(code);
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, String code, Object ... info) throws FileSystemException {
        if (obj == null) {
            throw new FileSystemException(code, info);
        }
        return obj;
    }

    public FileSystemException(String code) {
        this(code, null, (Object[])null);
    }

    public FileSystemException(String code, Object info0) {
        this(code, null, info0);
    }

    public FileSystemException(String code, Object info0, Throwable throwable) {
        this(code, throwable, info0);
    }

    public FileSystemException(String code, Object ... info) {
        this(code, null, info);
    }

    public FileSystemException(String code, Throwable throwable) {
        this(code, throwable, (Object[])null);
    }

    @Deprecated
    public FileSystemException(String code, Object[] info, Throwable throwable) {
        this(code, throwable, info);
    }

    public FileSystemException(String code, Throwable throwable, Object ... info) {
        super(code, throwable);
        if (info == null) {
            this.info = new String[0];
        } else {
            this.info = new String[info.length];
            for (int i = 0; i < info.length; ++i) {
                String value = String.valueOf(info[i]);
                Matcher urlMatcher = URL_PATTERN.matcher(value);
                if (urlMatcher.find()) {
                    Matcher pwdMatcher = PASSWORD_PATTERN.matcher(value);
                    value = pwdMatcher.replaceFirst(":***@");
                }
                this.info[i] = value;
            }
        }
    }

    public FileSystemException(Throwable throwable) {
        this(throwable.getMessage(), throwable, (Object[])null);
    }

    @Override
    public String getMessage() {
        return Messages.getString(super.getMessage(), this.getInfo());
    }

    public String getCode() {
        return super.getMessage();
    }

    public String[] getInfo() {
        return this.info;
    }
}

