/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition;

import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.protocols.raft.partition.RaftPartitionGroup;
import io.atomix.storage.StorageLevel;
import io.atomix.utils.memory.MemorySize;
import java.util.HashSet;
import java.util.Set;

public class RaftPartitionGroupConfig
extends PartitionGroupConfig<RaftPartitionGroupConfig> {
    private static final int DEFAULT_PARTITIONS = 7;
    private static final String DATA_PREFIX = ".data";
    private Set<String> members = new HashSet<String>();
    private int partitionSize;
    private String storageLevel = StorageLevel.MAPPED.name();
    private long segmentSize = 0x2000000L;
    private boolean flushOnCommit = true;
    private String dataDirectory;

    public PartitionGroup.Type getType() {
        return RaftPartitionGroup.TYPE;
    }

    protected int getDefaultPartitions() {
        return 7;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public RaftPartitionGroupConfig setMembers(Set<String> members) {
        this.members = members;
        return this;
    }

    public int getPartitionSize() {
        return this.partitionSize;
    }

    public RaftPartitionGroupConfig setPartitionSize(int partitionSize) {
        this.partitionSize = partitionSize;
        return this;
    }

    public String getStorageLevel() {
        return this.storageLevel;
    }

    public RaftPartitionGroupConfig setStorageLevel(String storageLevel) {
        StorageLevel.valueOf((String)storageLevel.toUpperCase());
        this.storageLevel = storageLevel;
        return this;
    }

    public MemorySize getSegmentSize() {
        return MemorySize.from((long)this.segmentSize);
    }

    public RaftPartitionGroupConfig setSegmentSize(MemorySize segmentSize) {
        this.segmentSize = segmentSize.bytes();
        return this;
    }

    public boolean isFlushOnCommit() {
        return this.flushOnCommit;
    }

    public RaftPartitionGroupConfig setFlushOnCommit(boolean flushOnCommit) {
        this.flushOnCommit = flushOnCommit;
        return this;
    }

    public String getDataDirectory() {
        return this.dataDirectory != null ? this.dataDirectory : ".data/" + this.getName();
    }

    public RaftPartitionGroupConfig setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
        return this;
    }
}

