/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.protocols.raft.MultiRaftProtocol;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.atomix.protocols.raft.partition.RaftPartitionGroupConfig;
import io.atomix.storage.StorageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftPartitionGroup
implements ManagedPartitionGroup {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftPartitionGroup.class);
    private final String name;
    private final RaftPartitionGroupConfig config;
    private final int partitionSize;
    private final Map<PartitionId, RaftPartition> partitions = Maps.newConcurrentMap();
    private final List<PartitionId> sortedPartitionIds = Lists.newCopyOnWriteArrayList();
    private Collection<PartitionMetadata> metadata;

    public static Builder builder(String name) {
        return new Builder((RaftPartitionGroupConfig)new RaftPartitionGroupConfig().setName(name));
    }

    private static Collection<RaftPartition> buildPartitions(RaftPartitionGroupConfig config) {
        File partitionsDir = new File(config.getDataDirectory(), "partitions");
        ArrayList<RaftPartition> partitions = new ArrayList<RaftPartition>(config.getPartitions());
        for (int i = 0; i < config.getPartitions(); ++i) {
            partitions.add(new RaftPartition(PartitionId.from((String)config.getName(), (int)(i + 1)), StorageLevel.valueOf((String)config.getStorageLevel().toUpperCase()), config.getSegmentSize().bytes(), config.isFlushOnCommit(), new File(partitionsDir, String.valueOf(i + 1))));
        }
        return partitions;
    }

    public RaftPartitionGroup(RaftPartitionGroupConfig config) {
        this.name = config.getName();
        this.config = config;
        this.partitionSize = config.getPartitionSize();
        RaftPartitionGroup.buildPartitions(config).forEach(p -> {
            this.partitions.put(p.id(), (RaftPartition)p);
            this.sortedPartitionIds.add(p.id());
        });
        Collections.sort(this.sortedPartitionIds);
    }

    public String name() {
        return this.name;
    }

    public PartitionGroup.Type type() {
        return TYPE;
    }

    public PrimitiveProtocol.Type protocol() {
        return MultiRaftProtocol.TYPE;
    }

    public PartitionGroupConfig config() {
        return this.config;
    }

    public ProxyProtocol newProtocol() {
        return MultiRaftProtocol.builder(this.name).withRecoveryStrategy(Recovery.RECOVER).withMaxRetries(5).build();
    }

    public RaftPartition getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    public Collection<Partition> getPartitions() {
        return this.partitions.values();
    }

    public List<PartitionId> getPartitionIds() {
        return this.sortedPartitionIds;
    }

    public CompletableFuture<ManagedPartitionGroup> join(PartitionManagementService managementService) {
        this.metadata = this.buildPartitions();
        List<CompletableFuture> futures = this.metadata.stream().map(metadata -> {
            RaftPartition partition = this.partitions.get(metadata.id());
            return partition.open((PartitionMetadata)metadata, managementService);
        }).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    public CompletableFuture<ManagedPartitionGroup> connect(PartitionManagementService managementService) {
        return this.join(managementService);
    }

    private Collection<PartitionMetadata> buildPartitions() {
        ArrayList sorted = new ArrayList(this.config.getMembers().stream().map(MemberId::from).collect(Collectors.toSet()));
        Collections.sort(sorted);
        int partitionSize = this.partitionSize;
        if (partitionSize == 0) {
            partitionSize = sorted.size();
        }
        int length = sorted.size();
        int count = Math.min(partitionSize, length);
        HashSet metadata = Sets.newHashSet();
        for (int i = 0; i < this.partitions.size(); ++i) {
            PartitionId partitionId = this.sortedPartitionIds.get(i);
            HashSet set = new HashSet(count);
            for (int j = 0; j < count; ++j) {
                set.add(sorted.get((i + j) % length));
            }
            metadata.add(new PartitionMetadata(partitionId, set));
        }
        return metadata;
    }

    public CompletableFuture<Void> close() {
        List<CompletableFuture> futures = this.partitions.values().stream().map(RaftPartition::close).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> LOGGER.info("Stopped"));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("partitions", this.partitions).toString();
    }

    public static class Builder
    extends PartitionGroup.Builder<RaftPartitionGroupConfig> {
        protected Builder(RaftPartitionGroupConfig config) {
            super((PartitionGroupConfig)config);
        }

        public Builder withMembers(String ... members) {
            return this.withMembers(Arrays.asList(members));
        }

        public Builder withMembers(MemberId ... members) {
            return this.withMembers(Stream.of(members).map(nodeId -> (String)((Object)nodeId.id())).collect(Collectors.toList()));
        }

        public Builder withMembers(Member ... members) {
            return this.withMembers(Stream.of(members).map(node -> (String)((Object)node.id().id())).collect(Collectors.toList()));
        }

        public Builder withMembers(Collection<String> members) {
            ((RaftPartitionGroupConfig)this.config).setMembers(Sets.newHashSet((Iterable)((Iterable)Preconditions.checkNotNull(members, (Object)"members cannot be null"))));
            return this;
        }

        public Builder withNumPartitions(int numPartitions) {
            ((RaftPartitionGroupConfig)this.config).setPartitions(numPartitions);
            return this;
        }

        public Builder withPartitionSize(int partitionSize) {
            ((RaftPartitionGroupConfig)this.config).setPartitionSize(partitionSize);
            return this;
        }

        public Builder withStorageLevel(StorageLevel storageLevel) {
            ((RaftPartitionGroupConfig)this.config).setStorageLevel(storageLevel.name());
            return this;
        }

        public Builder withDataDirectory(File dataDir) {
            ((RaftPartitionGroupConfig)this.config).setDataDirectory(new File("user.dir").toURI().relativize(dataDir.toURI()).getPath());
            return this;
        }

        public RaftPartitionGroup build() {
            return new RaftPartitionGroup((RaftPartitionGroupConfig)this.config);
        }
    }

    public static class Type
    implements PartitionGroup.Type<RaftPartitionGroupConfig> {
        private static final String NAME = "raft";

        public String name() {
            return NAME;
        }

        public RaftPartitionGroupConfig newConfig() {
            return new RaftPartitionGroupConfig();
        }

        public ManagedPartitionGroup newPartitionGroup(RaftPartitionGroupConfig config) {
            return new RaftPartitionGroup(config);
        }
    }
}

