/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.name;

import javax.jcr.NamespaceException;
import javax.jcr.Session;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameException;
import org.apache.jackrabbit.name.NameResolver;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.SessionNamespaceResolver;

public class ParsingNameResolver
implements NameResolver {
    private static final boolean[] MAYBE_INVALID = new boolean[128];
    private final NamespaceResolver resolver;

    private static boolean maybeInvalid(char ch) {
        if (ch < MAYBE_INVALID.length) {
            return MAYBE_INVALID[ch];
        }
        return Character.isSpaceChar(ch);
    }

    public ParsingNameResolver(NamespaceResolver resolver) {
        this.resolver = resolver;
    }

    public ParsingNameResolver(Session session) {
        this(new SessionNamespaceResolver(session));
    }

    public QName getQName(String name) throws NameException, NamespaceException {
        int length = name.length();
        int colon = -1;
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (!ParsingNameResolver.maybeInvalid(ch)) continue;
            if (ch == ':' && colon == -1 && 0 < i && i + 1 < length) {
                colon = i;
                continue;
            }
            if (ch == ' ' && colon + 1 < i && i + 1 < length || ch == '.' && (i > 0 || length > 2 || length == 2 && name.charAt(1) != '.')) continue;
            throw new IllegalNameException("Invalid name: " + name);
        }
        if (length == 0) {
            throw new IllegalNameException("Empty name");
        }
        if (colon == -1) {
            return new QName("", name);
        }
        String uri = this.resolver.getURI(name.substring(0, colon));
        return new QName(uri, name.substring(colon + 1));
    }

    public String getJCRName(QName name) throws NamespaceException {
        String uri = name.getNamespaceURI();
        if (uri.length() == 0) {
            return name.getLocalName();
        }
        return this.resolver.getPrefix(uri) + ":" + name.getLocalName();
    }

    static {
        for (char ch = '\u0000'; ch < MAYBE_INVALID.length; ch = (char)(ch + '\u0001')) {
            ParsingNameResolver.MAYBE_INVALID[ch] = Character.isSpaceChar(ch);
        }
        ParsingNameResolver.MAYBE_INVALID[46] = true;
        ParsingNameResolver.MAYBE_INVALID[58] = true;
        ParsingNameResolver.MAYBE_INVALID[47] = true;
        ParsingNameResolver.MAYBE_INVALID[91] = true;
        ParsingNameResolver.MAYBE_INVALID[93] = true;
        ParsingNameResolver.MAYBE_INVALID[42] = true;
        ParsingNameResolver.MAYBE_INVALID[124] = true;
        ParsingNameResolver.MAYBE_INVALID[34] = true;
        ParsingNameResolver.MAYBE_INVALID[39] = true;
    }
}

