/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Cvs;
import org.apache.tools.ant.taskdefs.cvslib.CvsTagEntry;
import org.apache.tools.ant.util.FileUtils;

public class CvsTagDiff
extends Task {
    static final String FILE_IS_NEW = " is new; current revision ";
    static final String FILE_HAS_CHANGED = " changed from revision ";
    static final String FILE_WAS_REMOVED = " is removed";
    private Cvs m_cvs;
    private String m_package;
    private String m_rootDir;
    private String m_startTag;
    private String m_endTag;
    private String m_startDate;
    private String m_endDate;
    private File m_destfile;
    private FileUtils m_fileUtils = FileUtils.newFileUtils();

    public void init() throws BuildException {
        this.m_cvs = (Cvs)this.getProject().createTask("cvs");
    }

    public void setCompressionLevel(int level) {
        this.m_cvs.setCompressionLevel(level);
    }

    public void setCompression(boolean usecomp) {
        this.m_cvs.setCompression(usecomp);
    }

    public void setCvsRoot(String cvsRoot) {
        this.m_cvs.setCvsRoot(cvsRoot);
    }

    public void setCvsRsh(String rsh) {
        this.m_cvs.setCvsRsh(rsh);
    }

    public void setPackage(String p) {
        this.m_package = p;
    }

    public void setRootDir(String dir) {
        this.m_rootDir = dir;
    }

    public void setQuiet(boolean quiet) {
        this.m_cvs.setQuiet(quiet);
    }

    public void setPort(int port) {
        this.m_cvs.setPort(port);
    }

    public void setPassfile(File f) {
        this.m_cvs.setPassfile(f);
    }

    public void setFailOnError(boolean b) {
        this.m_cvs.setFailOnError(b);
    }

    public void setStartTag(String s) {
        this.m_startTag = s;
    }

    public void setStartDate(String s) {
        this.m_startDate = s;
    }

    public void setEndTag(String s) {
        this.m_endTag = s;
    }

    public void setEndDate(String s) {
        this.m_endDate = s;
    }

    public void setDestFile(File f) {
        this.m_destfile = f;
    }

    public void execute() throws BuildException {
        block3: {
            this.validate();
            String rdiff = "rdiff -s " + (this.m_startTag != null ? "-r " + this.m_startTag : "-D " + this.m_startDate) + " " + (this.m_endTag != null ? "-r " + this.m_endTag : "-D " + this.m_endDate) + " " + this.m_package;
            this.log("Cvs command is " + rdiff, 3);
            this.m_cvs.setCommand(rdiff);
            File tmpFile = null;
            try {
                tmpFile = this.m_fileUtils.createTempFile("cvstagdiff", ".log", null);
                this.m_cvs.setOutput(tmpFile);
                this.m_cvs.execute();
                CvsTagEntry[] entries = this.parseRDiff(tmpFile);
                this.writeTagDiff(entries);
                Object var5_4 = null;
                if (tmpFile == null) break block3;
                tmpFile.delete();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CvsTagEntry[] parseRDiff(File tmpFile) throws BuildException {
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(tmpFile));
                String line = reader.readLine();
                int headerLength = this.getHeaderLength(line);
                Vector<CvsTagEntry> entries = new Vector<CvsTagEntry>();
                CvsTagEntry entry = null;
                while (true) {
                    String filename;
                    if (null == line) break;
                    int index = (line = line.substring(headerLength)).indexOf(FILE_IS_NEW);
                    if (index != -1) {
                        filename = line.substring(0, index);
                        String rev = line.substring(index + FILE_IS_NEW.length());
                        entry = new CvsTagEntry(filename, rev);
                        entries.addElement(entry);
                        this.log(entry.toString(), 3);
                    } else {
                        index = line.indexOf(FILE_HAS_CHANGED);
                        if (index != -1) {
                            filename = line.substring(0, index);
                            int revSeparator = line.indexOf(" to ", index);
                            String prevRevision = line.substring(index + FILE_HAS_CHANGED.length(), revSeparator);
                            String revision = line.substring(revSeparator + 4);
                            entry = new CvsTagEntry(filename, revision, prevRevision);
                            entries.addElement(entry);
                            this.log(entry.toString(), 3);
                        } else {
                            index = line.indexOf(FILE_WAS_REMOVED);
                            if (index != -1) {
                                filename = line.substring(0, index);
                                entry = new CvsTagEntry(filename);
                                entries.addElement(entry);
                                this.log(entry.toString(), 3);
                            }
                        }
                    }
                    line = reader.readLine();
                }
                Object[] array = new CvsTagEntry[entries.size()];
                entries.copyInto(array);
                Object[] objectArray = array;
                Object var13_14 = null;
                if (reader == null) return objectArray;
                try {
                    reader.close();
                    return objectArray;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return objectArray;
            }
            catch (IOException e) {
                throw new BuildException("Error in parsing", e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (reader == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            reader.close();
            throw throwable;
        }
    }

    private int getHeaderLength(String line) {
        boolean trimFileName = line.startsWith("File " + this.m_package);
        int prefixLength = "File ".length();
        int suffixLength = 0;
        int rootDirLength = 0;
        if (null != this.m_rootDir) {
            rootDirLength = this.m_rootDir.length();
            suffixLength = rootDirLength > 0 && this.m_rootDir.endsWith("/") ? 1 : 0;
        } else if (trimFileName) {
            rootDirLength = this.m_package.length();
            suffixLength = 1;
        }
        int headerLength = prefixLength + rootDirLength + suffixLength;
        return headerLength;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeTagDiff(CvsTagEntry[] entries) throws BuildException {
        FileOutputStream output = null;
        output = new FileOutputStream(this.m_destfile);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)output, "UTF-8"));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print("<tagdiff ");
        if (this.m_startTag != null) {
            writer.print("startTag=\"" + this.m_startTag + "\" ");
        } else {
            writer.print("startDate=\"" + this.m_startDate + "\" ");
        }
        if (this.m_endTag != null) {
            writer.print("endTag=\"" + this.m_endTag + "\" ");
        } else {
            writer.print("endDate=\"" + this.m_endDate + "\" ");
        }
        writer.println(">");
        int i = 0;
        int c = entries.length;
        while (i < c) {
            this.writeTagEntry(writer, entries[i]);
            ++i;
        }
        writer.println("</tagdiff>");
        writer.flush();
        writer.close();
        Object var7_8 = null;
        if (null == output) return;
        try {
            output.close();
            return;
        }
        catch (IOException ioe) {}
        return;
        {
            catch (UnsupportedEncodingException uee) {
                this.log(uee.toString(), 0);
                Object var7_9 = null;
                if (null == output) return;
                try {
                    output.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (null == output) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void writeTagEntry(PrintWriter writer, CvsTagEntry entry) {
        writer.println("\t<entry>");
        writer.println("\t\t<file>");
        writer.println("\t\t\t<name>" + entry.getFile() + "</name>");
        if (entry.getRevision() != null) {
            writer.println("\t\t\t<revision>" + entry.getRevision() + "</revision>");
        }
        if (entry.getPreviousRevision() != null) {
            writer.println("\t\t\t<prevrevision>" + entry.getPreviousRevision() + "</prevrevision>");
        }
        writer.println("\t\t</file>");
        writer.println("\t</entry>");
    }

    private void validate() throws BuildException {
        if (null == this.m_package) {
            throw new BuildException("Package/module must be set.");
        }
        if (null == this.m_destfile) {
            throw new BuildException("Destfile must be set.");
        }
        if (null == this.m_startTag && null == this.m_startDate) {
            throw new BuildException("Start tag or start date must be set.");
        }
        if (null != this.m_startTag && null != this.m_startDate) {
            throw new BuildException("Only one of start tag and start date must be set.");
        }
        if (null == this.m_endTag && null == this.m_endDate) {
            throw new BuildException("End tag or end date must be set.");
        }
        if (null != this.m_endTag && null != this.m_endDate) {
            throw new BuildException("Only one of end tag and end date must be set.");
        }
    }
}

