Apache Axiom 1.3.0 Release Note
===============================

Changes in this release
-----------------------

*   Axiom now requires at least Java 7:

    *   Explicit dependencies on APIs that were not part of the JRE in Java 5
        (Activation, StAX and JAXB) have been removed.
    *   The public API now uses generics. Note that this should in general not
        have impact on binary compatibility with Axiom 1.2.x.

*   In Axiom 1.2.x several APIs were using `Object` as argument/return type
    although they expect/return a `DataHandler`. This is a legacy of Axis 1.x
    where the Activation API was an optional dependency. This no longer makes
    sense:

    *   In Java 6, the Activation API is part of the JRE.
    *   It is unlikely that Axiom actually works if the Activation API is not
        available: there is nothing in the build that enforces or tests that,
        and there are no known downstream projects that use Axiom without also
        depending on the Activation API.

    In Axiom 1.3.0, the following APIs have been changed to use `DataHandler`
    instead of `Object`:

    *   `OMText.getDataHandler()`
    *   `OMFactory.createOMText(Object, boolean)`

    Bridge methods have been added to ensure binary compatibility with Axiom
    1.2.x.

*   By default, parsers created by Axiom are now non coalescing and have CDATA
    section reporting enabled.

*   The builder implementations and related classes have been removed from the
    `org.apache.axiom.om.impl.builder` and `org.apache.axiom.soap.impl.builder`
    packages. This includes the `StAXBuilder`, `StAXOMBuilder`,
    `XOPAwareStAXOMBuilder`, `StAXSOAPModelBuilder` and `MTOMStAXSOAPModelBuilder`
    classes.

    This change was necessary to enable a refactoring and complete overhaul of
    the builders.

    As explained in the Axiom 1.2.11 release notes, application code
    should use the `OMXMLBuilderFactory` API to create builders. Code written for
    Axiom 1.2.x that uses that API remains compatible with Axiom 1.3.x.

*   The `detach` method no longer causes the node to be built. This change was
    made possible by the new builder design.

*   Several methods have been removed from the `OMXMLParserWrapper` interface.
    This includes formerly deprecated methods as well as methods that would
    allow manipulation of the state of the underlying parser.

*   The `BuilderAwareReader` API introduced by [AXIOM-268][] has been removed
    without replacement. There are multiple reasons for this:

    *   The only method defined by the `BuilderAwareReader` interface has a
        parameter of type `StAXBuilder`, but that class has been removed from
        the public API (see above). The parameter type would have to be changed
        to `OMXMLParserWrapper`.
    *   If the interface is considered a public API, then it is placed in the
        wrong package (`org.apache.axiom.om.impl.builder`).
    *   There are no known usages of that API.
    *   The API is merely a convenience, but doesn't provide any additional
        feature: since a builder only starts consuming the `XMLStreamReader` on
        demand, a reference to the builder can be injected into the custom
        "builder aware" reader after the builder has been created.

[AXIOM-268]: https://issues.apache.org/jira/browse/AXIOM-268

*   Some (most? all?) of the classes in `axiom-compat` have been removed.

*   Support for the `SOAPConstants.SOAPBODY_FIRST_CHILD_ELEMENT_QNAME` property
    introduced by [AXIOM-282][] has been retired.

[AXIOM-282]: https://issues.apache.org/jira/browse/AXIOM-282

*   The legacy behavior for `getChildrenWithName` implemented by [AXIOM-11][]
    is no longer supported. In Axiom 1.3.0 the QName matching is always strict.

[AXIOM-11]: https://issues.apache.org/jira/browse/AXIOM-11

*   The legacy behavior for `declareNamesapce` (where an empty prefix is
    interpreted in the same way as a null value) is no longer supported.
    See [AXIOM-375][].

*   Elements no longer store line number information, and the corresponding
    methods on the `OMElement` interface have been deprecated.

*   The `CustomBuilder` and `CustomBuilderSupport` interfaces have changed in
    an incompatible way. Note that this API was designed to enable some very
    specific optimizations in Axis2, so that this change should have limited
    impact.
    
    In addition to the interface changes, the API no longer gives access to the
    raw `XMLStreamReader` returned by the StAX implementation. That feature was
    originally introduced to allow negotiation of additional optimizations
    between proprietary StAX and JAXB implementations from a particular vendor.
    That feature is no longer necessary and has been removed to allow a
    simplification of the builder design.

*   In Axiom 1.2.x, `StAXUtils` by default kept per class loader maps of
    `XMLInputFactory` and `XMLOutputFactory` instances (where the key was the
    thread context class loader). These maps were implemented as
    `WeakHashMap<ClassLoader,XMLInputFactory>` and `WeakHashMap<ClassLoader,XMLOutputFactory>`.
    The problem with this approach is that it may cause a class loader leak if
    the `XMLInputFactory` or `XMLOutputFactory` instance has a strong reference
    to the `ClassLoader` used as key. That case occurs in two scenarios:

    1.  A StAX implementation is loaded by a class loader that is neither the
        class loader that loads StAXUtils nor one of its parent class loaders,
        and that class loader is set as the context class loader when
        `StAXUtils` is used. Note that this is basically the use case for which
        the per class loader maps were originally designed.
    2.  For whatever reason, the `XMLInputFactory`/`XMLOutputFactory` instance
        keeps a strong reference to the thread context class loader set when
        the instance was created. In that scenario, if `StAXUtils` is used with
        a thread context class loader that is set to any class loader other than
        the one that loaded `StAXUtils` or one of its parents, then `StAXUtils`
        will prevent that class loader from being garbage collected. This type
        of behavior has been [reported](http://markmail.org/message/2kfstgjckrgiimmt)
        for the default StAX implementation in the Oracle JRE; Woodstox is
        probably not affected.

    The scenario for which the per class loader feature was designed is probably
    very rare. As shown above, that scenario is always prone to class loader
    leaks. Therefore this feature has been removed without replacement in Axiom
    1.3.0, and `StAXUtils` now always loads the StAX implementation visible to
    its own class loader. Note that this mode was already supported in Axiom
    1.2.x, but it was not the default.

*   The `getNodeValue` and `setNodeValue` methods have been removed from the
    `SOAPFaultNode` interface because they conflict with methods defined by
    DOM's `Node` interface. Note that these methods were already deprecated in
    Axiom 1.2.x, with alternative methods being available.

*   The `SOAPFaultCode` implementations for SOAP 1.2 no longer override the
    `getTextAsQName` method (which was an undocumented feature used by Axis2).
    Use the `getValueAsQName` to retrieve the fault code value in a version
    independent manner.

*   In Axiom 1.2.x the `SOAPMessage` and `SOAPEnvelope` implementations had
    special serialization logic, causing the serialization of a `SOAPEnvelope`
    to emit an XML declaration by default and the serialization of a
    `SOAPMessage` to skip all content in the prolog and epilog. This behavior
    was completely undocumented and violates basic object oriented design
    principles: although `SOAPMessage` is an `OMDocument` and `SOAPEnvelope` is
    an `OMElement`, they didn't behave in the same way as `OMDocument` and
    `OMElement` when it comes to serialization. This in turn led to an awkward
    design. This special serialization logic has been removed in Axiom 1.3 and
    `SOAPMessage` and `SOAPEnvelope` now have the same behavior as any other
    `OMDocument` and `OMElement`. The main implication is that the serialization
    of a `SOAPEnvelope` no longer generates an XML declaration. This change also
    fixes [AXIOM-474][].

*   In Axiom 1.3.0, the `getBuilder` method always returns `null` for document
    and elements that are (locally) complete, i.e. for which the end event has
    been processed. That means that after completion, nodes created by a builder
    will be indistinguishable from programmatically created nodes.

*   The `OMXMLStreamReader` interface has been removed because all if its
    usages were already deprecated in 1.2.x.

*   Support for the legacy `XMLStreamReader` extension for optimized base64
    handling has been removed. The only supported mechanism in Axiom 1.3.x is
    defined by the `DataHandlerReader` API.

*   The `MimePartProvider` interface has been moved to `org.apache.axiom.mime`.

*   The `MTOMXMLStreamWriter` class is now abstract. It is not meant to be
    instantiated by code outside of Axiom; the Javadoc of the `OMDataSource`
    interface describes the only supported interactions with the
    `MTOMXMLStreamWriter` API.

*   The `XMLStreamWriterFilter` API and the support for it in `OMOutputFormat`
    and `MTOMXMLStreamWriter` have been removed. There are multiple reasons for
    this:

    *   Since `MTOMXMLStreamWriter` is now an abstract class, it is possible to
        create `MTOMXMLStreamWriter` wrappers to achieve essentially the same
        result as installing an `XMLStreamWriterFilter` on an
        `MTOMXMLStreamWriter`.

    *   The API violated the API layering because `XMLStreamWriterFilter` was
        part of a utility package (`org.apache.axiom.om.util`), but used in the
        interface of a core API, namely `org.apache.axiom.om.OMOutputFormat`.

    *   An `XMLStreamWriterFilter` specified using `OMOutputFormat` was applied
        only when serializing to an `OutputStream`, but not to a `Writer` or
        `XMLStreamWriter`.

    *   The implementation had insufficient test coverage. In particular, the
        `setFilter` and `removeFilter` methods in `MTOMXMLStreamWriter` had
        no coverage at all.

    *   Since the same `XMLStreamWriterFilter` instance can't be used
        concurrently, the presence of a property of that type in
        `OMOutputFormat` makes that class thread unsafe.

*   The `axiom-c14n` artifact has been removed without replacement. Use DOOM
    together with [Apache Santuario](http://santuario.apache.org/) instead.

[AXIOM-375]: https://issues.apache.org/jira/browse/AXIOM-375
[AXIOM-474]: https://issues.apache.org/jira/browse/AXIOM-474
