/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.application;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.util.collections.UrlExternalFormComparator;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundClassResolver
implements IClassResolver {
    private static final Logger logger = LoggerFactory.getLogger(CompoundClassResolver.class);
    private final List<IClassResolver> resolvers = new CopyOnWriteArrayList<IClassResolver>();

    @Override
    public Class<?> resolveClass(String className) throws ClassNotFoundException {
        boolean debugEnabled = logger.isDebugEnabled();
        for (IClassResolver resolver : this.resolvers) {
            try {
                return resolver.resolveClass(className);
            }
            catch (ClassNotFoundException cnfx) {
                if (!debugEnabled) continue;
                logger.debug("ClassResolver '{}' cannot find class: '{}'", (Object)resolver.getClass().getName(), (Object)className);
            }
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Iterator<URL> getResources(String name) {
        Args.notNull(name, "name");
        TreeSet<URL> urls = new TreeSet<URL>(new UrlExternalFormComparator());
        for (IClassResolver resolver : this.resolvers) {
            Iterator<URL> it = resolver.getResources(name);
            while (it.hasNext()) {
                URL url = it.next();
                urls.add(url);
            }
        }
        return urls.iterator();
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader classLoader = !this.resolvers.isEmpty() ? this.resolvers.iterator().next().getClassLoader() : Thread.currentThread().getContextClassLoader();
        return classLoader;
    }

    public CompoundClassResolver add(IClassResolver resolver) {
        Args.notNull(resolver, "resolver");
        this.resolvers.add(resolver);
        return this;
    }

    public CompoundClassResolver remove(IClassResolver resolver) {
        this.resolvers.remove(resolver);
        return this;
    }
}

