/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.application;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.util.collections.UrlExternalFormComparator;

public abstract class AbstractClassResolver
implements IClassResolver {
    private final ConcurrentMap<String, WeakReference<Class<?>>> classes = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class<?> resolveClass(String className) throws ClassNotFoundException {
        Class<Comparable<Byte>> clazz = null;
        WeakReference ref = (WeakReference)this.classes.get(className);
        if (ref != null) {
            clazz = (Class<Byte>)ref.get();
        }
        if (clazz == null) {
            switch (className) {
                case "byte": {
                    clazz = Byte.TYPE;
                    break;
                }
                case "short": {
                    clazz = Short.TYPE;
                    break;
                }
                case "int": {
                    clazz = Integer.TYPE;
                    break;
                }
                case "long": {
                    clazz = Long.TYPE;
                    break;
                }
                case "float": {
                    clazz = Float.TYPE;
                    break;
                }
                case "double": {
                    clazz = Double.TYPE;
                    break;
                }
                case "boolean": {
                    clazz = Boolean.TYPE;
                    break;
                }
                case "char": {
                    clazz = Character.TYPE;
                    break;
                }
                default: {
                    ConcurrentMap<String, WeakReference<Class<?>>> concurrentMap = this.classes;
                    synchronized (concurrentMap) {
                        clazz = Class.forName(className, false, this.getClassLoader());
                        if (clazz == null) {
                            throw new ClassNotFoundException(className);
                        }
                    }
                    this.classes.put(className, new WeakReference<Class<Byte>>(clazz));
                }
            }
        }
        return clazz;
    }

    @Override
    public Iterator<URL> getResources(String name) {
        TreeSet<URL> resultSet = new TreeSet<URL>((Comparator<URL>)new UrlExternalFormComparator());
        try {
            Enumeration<URL> resources = Application.class.getClassLoader().getResources(name);
            this.loadResources(resources, resultSet);
            resources = Application.get().getClass().getClassLoader().getResources(name);
            this.loadResources(resources, resultSet);
            resources = this.getClassLoader().getResources(name);
            this.loadResources(resources, resultSet);
        }
        catch (Exception e) {
            throw new WicketRuntimeException(e);
        }
        return resultSet.iterator();
    }

    private void loadResources(Enumeration<URL> resources, Set<URL> loadedResources) {
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                loadedResources.add(url);
            }
        }
    }
}

