/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.bean.validation;

import java.util.ArrayList;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.reference.ClassReference;

public class GroupsModel
extends LoadableDetachableModel<Class<?>[]> {
    private static final Class<?>[] EMPTY = new Class[0];
    private final ArrayList<ClassReference<?>> groups;

    public GroupsModel(Class<?> ... groups) {
        if (groups == null || groups.length == 0) {
            this.groups = null;
        } else {
            this.groups = new ArrayList();
            for (Class<?> group : groups) {
                this.groups.add(ClassReference.of(group));
            }
            this.groups.trimToSize();
        }
    }

    protected Class<?>[] load() {
        if (this.groups == null) {
            return EMPTY;
        }
        Class[] classes = new Class[this.groups.size()];
        for (int i = 0; i < this.groups.size(); ++i) {
            classes[i] = this.groups.get(i).get();
        }
        return classes;
    }
}

