/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi.conditions.geo;

import java.util.HashMap;
import java.util.Map;

public enum DistanceUnit {
    KILOMETERS(1000.0, "km", "kilometers"),
    MILES(1609.344, "mi", "miles"),
    YARDS(0.9144, "yd", "yards"),
    FEET(0.3048, "ft", "feet"),
    INCHES(0.0254, "in", "inches"),
    NAUTICAL_MILES(1852.0, "NM", "nauticalmiles"),
    METERS(1.0, "m", "meters");

    private static final double EARTH_SEMI_MAJOR_AXIS = 6378137.0;
    private static final double EARTH_EQUATOR = 4.007501668557849E7;
    private static final Map<String, DistanceUnit> UNIT_MAP;
    public static final DistanceUnit DEFAULT;
    private final double metersPerUnit;
    private final String[] aliases;

    private DistanceUnit(double metersPerUnit, String ... aliases) {
        this.metersPerUnit = metersPerUnit;
        this.aliases = aliases;
    }

    public double getEarthCircumference() {
        return 4.007501668557849E7 / this.metersPerUnit;
    }

    public double getEarthRadius() {
        return 6378137.0 / this.metersPerUnit;
    }

    public double getDistancePerDegree() {
        return 4.007501668557849E7 / (360.0 * this.metersPerUnit);
    }

    public double toMeters(double value) {
        return value * this.metersPerUnit;
    }

    public double fromMeters(double value) {
        return value / this.metersPerUnit;
    }

    public double convert(double value, DistanceUnit toUnit) {
        return value * this.metersPerUnit / toUnit.metersPerUnit;
    }

    public static double convert(double value, DistanceUnit from, DistanceUnit to) {
        return value * from.metersPerUnit / to.metersPerUnit;
    }

    public static DistanceUnit fromString(String unit) {
        if (unit == null || unit.isEmpty()) {
            throw new IllegalArgumentException("Unit string must not be null or empty");
        }
        DistanceUnit distanceUnit = UNIT_MAP.get(unit.toLowerCase());
        if (distanceUnit == null) {
            throw new IllegalArgumentException("Unknown distance unit: " + unit);
        }
        return distanceUnit;
    }

    public static DistanceUnit parseUnit(String distance, DistanceUnit defaultUnit) {
        for (DistanceUnit unit : DistanceUnit.values()) {
            for (String alias : unit.aliases) {
                if (!distance.endsWith(alias)) continue;
                return unit;
            }
        }
        return defaultUnit;
    }

    public double parse(String distance, DistanceUnit defaultUnit) {
        Distance parsed = Distance.parseDistance(distance, defaultUnit);
        return DistanceUnit.convert(parsed.value, parsed.unit, this);
    }

    public String toString() {
        return this.aliases[0];
    }

    static {
        UNIT_MAP = new HashMap<String, DistanceUnit>();
        DEFAULT = METERS;
        for (DistanceUnit unit : DistanceUnit.values()) {
            for (String alias : unit.aliases) {
                UNIT_MAP.put(alias.toLowerCase(), unit);
            }
        }
    }

    public static class Distance {
        public final double value;
        public final DistanceUnit unit;

        public Distance(double value, DistanceUnit unit) {
            this.value = value;
            this.unit = unit;
        }

        public Distance convert(DistanceUnit toUnit) {
            double convertedValue = DistanceUnit.convert(this.value, this.unit, toUnit);
            return new Distance(convertedValue, toUnit);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Distance other = (Distance)obj;
            return Double.compare(DistanceUnit.convert(this.value, this.unit, other.unit), other.value) == 0;
        }

        public int hashCode() {
            return Double.hashCode(this.value * this.unit.metersPerUnit);
        }

        public String toString() {
            return this.value + " " + this.unit.toString();
        }

        public static Distance parseDistance(String distance) {
            return Distance.parseDistance(distance, METERS);
        }

        public static Distance parseDistance(String distance, DistanceUnit defaultUnit) {
            for (DistanceUnit unit : DistanceUnit.values()) {
                for (String alias : unit.aliases) {
                    if (!distance.endsWith(alias)) continue;
                    String valuePart = distance.substring(0, distance.length() - alias.length()).trim();
                    return new Distance(Double.parseDouble(valuePart), unit);
                }
            }
            return new Distance(Double.parseDouble(distance), defaultUnit);
        }
    }
}

