/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.karaf.specs.locator.OsgiLocator;

class $FactoryFinder {
    private static final String DEFAULT_PACKAGE = "com.sun.xml.internal.";
    private static final Logger LOGGER = Logger.getLogger("javax.xml.stream");
    private static final Properties cacheProps = new Properties();
    private static volatile boolean firstTime = true;

    $FactoryFinder() {
    }

    private static Class getProviderClass(String className, ClassLoader cl, boolean doFallback, boolean useBSClsLoader) throws ClassNotFoundException {
        try {
            if (cl == null) {
                if (useBSClsLoader) {
                    return Class.forName(className, false, $FactoryFinder.class.getClassLoader());
                }
                cl = $FactoryFinder.getContextClassLoader();
                if (cl == null) {
                    throw new ClassNotFoundException();
                }
                return Class.forName(className, false, cl);
            }
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e1) {
            if (doFallback) {
                return Class.forName(className, false, $FactoryFinder.class.getClassLoader());
            }
            throw e1;
        }
    }

    static <T> T newInstance(Class<T> type, String className, ClassLoader cl, boolean doFallback) throws FactoryConfigurationError {
        return $FactoryFinder.newInstance(type, className, cl, doFallback, false);
    }

    static <T> T newInstance(Class<T> type, String className, ClassLoader cl, boolean doFallback, boolean useBSClsLoader) throws FactoryConfigurationError {
        assert (type != null);
        if (System.getSecurityManager() != null && className != null && className.startsWith(DEFAULT_PACKAGE)) {
            cl = null;
            useBSClsLoader = true;
        }
        try {
            Class providerClass = $FactoryFinder.getProviderClass(className, cl, doFallback, useBSClsLoader);
            if (!type.isAssignableFrom(providerClass)) {
                throw new ClassCastException(className + " cannot be cast to " + type.getName());
            }
            Object instance = providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ClassLoader clD = cl;
            LOGGER.fine(() -> "created new instance of " + providerClass + " using ClassLoader: " + clD);
            return type.cast(instance);
        }
        catch (ClassNotFoundException x) {
            throw new FactoryConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new FactoryConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static <T> T find(Class<T> type, String fallbackClassName) throws FactoryConfigurationError {
        return $FactoryFinder.find(type, type.getName(), null, fallbackClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T find(Class<T> type, String factoryId, ClassLoader cl, String fallbackClassName) throws FactoryConfigurationError {
        try {
            Class spiClass = OsgiLocator.locate(type, (String)factoryId);
            if (spiClass != null) {
                return spiClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Throwable spiClass) {
            // empty catch block
        }
        try {
            String systemProp = type.getName().equals(factoryId) ? $FactoryFinder.getSystemProperty(factoryId) : System.getProperty(factoryId);
            if (systemProp != null) {
                LOGGER.fine(() -> "found system property, value=" + systemProp);
                return $FactoryFinder.newInstance(type, systemProp, cl, true);
            }
        }
        catch (SecurityException se) {
            throw new FactoryConfigurationError("Failed to read factoryId '" + factoryId + "'", se);
        }
        try {
            String factoryClassName;
            if (firstTime) {
                Properties se = cacheProps;
                synchronized (se) {
                    if (firstTime) {
                        File stax;
                        firstTime = false;
                        String javaHome = $FactoryFinder.getSystemProperty("java.home");
                        String configFile = javaHome + File.separator + "conf" + File.separator + "jaxp.properties";
                        File jaxp = new File(configFile);
                        if ($FactoryFinder.doesFileExist(jaxp)) {
                            cacheProps.load($FactoryFinder.getFileInputStream(jaxp));
                        }
                        if ($FactoryFinder.doesFileExist(stax = new File(configFile = javaHome + File.separator + "conf" + File.separator + "stax.properties"))) {
                            cacheProps.load($FactoryFinder.getFileInputStream(stax));
                        }
                    }
                }
            }
            if ((factoryClassName = cacheProps.getProperty(factoryId)) != null) {
                return $FactoryFinder.newInstance(type, factoryClassName, cl, true);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error loading JDK properties file", ex);
        }
        if (type.getName().equals(factoryId)) {
            T provider = $FactoryFinder.findServiceProvider(type, cl);
            if (provider != null) {
                return provider;
            }
        } else assert (fallbackClassName == null);
        if (fallbackClassName == null) {
            throw new FactoryConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        LOGGER.fine(() -> "loaded from fallback value: " + fallbackClassName);
        return $FactoryFinder.newInstance(type, fallbackClassName, cl, true);
    }

    private static <T> T findServiceProvider(Class<T> type, ClassLoader cl) {
        try {
            return (T)AccessController.doPrivileged(() -> {
                ServiceLoader serviceLoader = ServiceLoader.load(type, cl != null ? cl : Thread.currentThread().getContextClassLoader());
                Iterator iterator = serviceLoader.iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                return null;
            });
        }
        catch (ServiceConfigurationError e) {
            RuntimeException x = new RuntimeException("Provider for " + type + " cannot be created", e);
            throw new FactoryConfigurationError(x, x.getMessage());
        }
    }

    private static ClassLoader getContextClassLoader() throws SecurityException {
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        });
    }

    private static String getSystemProperty(String propName) {
        return AccessController.doPrivileged(() -> System.getProperty(propName));
    }

    private static FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(() -> new FileInputStream(file));
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    private static boolean doesFileExist(File f) {
        return AccessController.doPrivileged(f::exists);
    }
}

