/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckService;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.LockHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultHealthCheckService
extends ServiceSupport
implements HealthCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHealthCheckService.class);
    private final ConcurrentMap<HealthCheck, HealthCheck.Result> checks = new ConcurrentHashMap<HealthCheck, HealthCheck.Result>();
    private final ConcurrentMap<String, Map<String, Object>> options = new ConcurrentHashMap<String, Map<String, Object>>();
    private final List<BiConsumer<HealthCheck.State, HealthCheck>> listeners = new ArrayList<BiConsumer<HealthCheck.State, HealthCheck>>();
    private final StampedLock lock = new StampedLock();
    private CamelContext camelContext;
    private ScheduledExecutorService executorService;
    private long checkInterval;
    private TimeUnit checkIntervalUnit;
    private volatile HealthCheckRegistry registry;
    private volatile ScheduledFuture<?> future;

    public DefaultHealthCheckService() {
        this(null);
    }

    public DefaultHealthCheckService(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.checkInterval = 30L;
        this.checkIntervalUnit = TimeUnit.SECONDS;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public HealthCheckRegistry getHealthCheckRegistry() {
        return this.registry;
    }

    public void setHealthCheckRegistry(HealthCheckRegistry registry) {
        this.registry = registry;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setCheckInterval(long interval, TimeUnit intervalUnit) {
        this.setCheckInterval(interval);
        this.setCheckIntervalUnit(intervalUnit);
    }

    public TimeUnit getCheckIntervalUnit() {
        return this.checkIntervalUnit;
    }

    public void setCheckIntervalUnit(TimeUnit checkIntervalUnit) {
        this.checkIntervalUnit = checkIntervalUnit;
    }

    @Override
    public void addStateChangeListener(BiConsumer<HealthCheck.State, HealthCheck> consumer) {
        LockHelper.doWithWriteLock(this.lock, () -> this.listeners.add(consumer));
    }

    @Override
    public void removeStateChangeListener(BiConsumer<HealthCheck.State, HealthCheck> consumer) {
        LockHelper.doWithWriteLock(this.lock, () -> this.listeners.removeIf(listener -> listener.equals(consumer)));
    }

    @Override
    public void setHealthCheckOptions(String id, Map<String, Object> options) {
        options.put(id, options);
    }

    @Override
    public Optional<HealthCheck.Result> call(String id) {
        return this.call(id, this.options.getOrDefault(id, Collections.emptyMap()));
    }

    @Override
    public Optional<HealthCheck.Result> call(String id, Map<String, Object> options) {
        return this.registry.getCheck(id).map(check -> this.invoke((HealthCheck)check, options));
    }

    @Override
    public void notify(HealthCheck check, HealthCheck.Result result) {
        LockHelper.doWithWriteLock(this.lock, () -> this.processResult(check, result));
    }

    @Override
    public Collection<HealthCheck.Result> getResults() {
        return new ArrayList<HealthCheck.Result>(this.checks.values());
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        if (this.executorService == null) {
            this.executorService = this.camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor(this, "DefaultHealthCheckService");
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.registry == null) {
            this.registry = this.camelContext.getHealthCheckRegistry();
        }
        if (ObjectHelper.isNotEmpty(this.registry) && ObjectHelper.isEmpty(this.future)) {
            LOGGER.debug("Schedule health-checks to be executed every %d (%s)", (Object)this.checkInterval, (Object)this.checkIntervalUnit.name());
            this.future = this.executorService.scheduleAtFixedRate(() -> {
                if (!this.isRunAllowed()) {
                    return;
                }
                LOGGER.debug("Invoke health-checks (scheduled)");
                this.registry.stream().collect(Collectors.groupingBy(HealthCheckHelper::getGroup)).entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).sorted(Comparator.comparingInt(HealthCheck::getOrder)).forEach(this::invoke);
            }, this.checkInterval, this.checkInterval, this.checkIntervalUnit);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if (this.executorService != null) {
            if (this.camelContext != null) {
                this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
            } else {
                this.executorService.shutdownNow();
            }
            this.executorService = null;
        }
    }

    private HealthCheck.Result processResult(HealthCheck check, HealthCheck.Result result) {
        HealthCheck.Result cachedResult = (HealthCheck.Result)this.checks.get(check);
        if (!this.isSameResult(result, cachedResult)) {
            this.listeners.forEach(listener -> listener.accept(result.getState(), check));
        }
        this.checks.put(check, result);
        return result;
    }

    private HealthCheck.Result invoke(HealthCheck check) {
        return this.invoke(check, this.options.getOrDefault(check.getId(), Collections.emptyMap()));
    }

    private HealthCheck.Result invoke(HealthCheck check, Map<String, Object> options) {
        return LockHelper.supplyWithWriteLock(this.lock, () -> {
            LOGGER.debug("Invoke health-check {}", (Object)check.getId());
            return this.processResult(check, check.call(options));
        });
    }

    private boolean isSameResult(HealthCheck.Result r1, HealthCheck.Result r2) {
        if (Objects.equals(r1, r2)) {
            return true;
        }
        if (r1 != null && r2 != null) {
            return r1.getState() == r2.getState();
        }
        return false;
    }
}

