/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.table;

import org.apache.karaf.shell.table.HAlign;

public class Col {
    private String header;
    int maxSize = -1;
    int size = 0;
    private HAlign align = HAlign.left;

    public Col(String header) {
        this.header = header;
    }

    public Col align(HAlign align) {
        this.align = align;
        return this;
    }

    public Col alignLeft() {
        this.align = HAlign.left;
        return this;
    }

    public Col alignRight() {
        this.align = HAlign.right;
        return this;
    }

    public Col alignCenter() {
        this.align = HAlign.center;
        return this;
    }

    public Col maxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    protected void updateSize(int cellSize) {
        if (this.size <= cellSize) {
            this.size = this.getClippedSize(cellSize);
        }
    }

    private int getClippedSize(int cellSize) {
        return this.maxSize == -1 ? cellSize : Math.min(cellSize, this.maxSize);
    }

    String format(Object cellData) {
        String fullContent;
        if (cellData == null) {
            cellData = "";
        }
        if ((fullContent = String.format("%s", cellData)).length() == 0) {
            return "";
        }
        String finalContent = fullContent.substring(0, this.getClippedSize(fullContent.length()));
        this.updateSize(finalContent.length());
        return finalContent;
    }

    String getHeader() {
        return this.header;
    }

    String getContent(String content) {
        return this.align.position(this.cut(content, this.size), this.size);
    }

    private String cut(String content, int size) {
        if (content.length() <= size) {
            return content;
        }
        return content.substring(0, Math.max(0, size - 1));
    }
}

