/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Verifier;
import aQute.bnd.version.Version;
import java.util.Objects;

public class BundleId
implements Comparable<BundleId> {
    final String bsn;
    final String version;

    public BundleId(String bsn, String version) {
        this.bsn = bsn.trim();
        this.version = version == null ? "0" : version.trim();
    }

    public BundleId(String bsn, Version version) {
        this.bsn = bsn;
        this.version = version.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public String getBsn() {
        return this.bsn;
    }

    public boolean isValid() {
        return Verifier.isVersion(this.version) && Verifier.isBsn(this.bsn);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BundleId && this.compareTo((BundleId)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.bsn, this.version);
    }

    @Override
    public int compareTo(BundleId other) {
        int result = this.bsn.compareTo(other.bsn);
        if (result != 0) {
            return result;
        }
        return this.version.compareTo(other.version);
    }

    public String toString() {
        return this.bsn + ";version=" + this.version;
    }

    public String getShortVersion() {
        try {
            Version v = new Version(this.version);
            return v.toStringWithoutQualifier();
        }
        catch (Exception e) {
            return this.version;
        }
    }
}

