/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.extension;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Requirement;

class BundleWires {
    long bundleId;
    Map<String, Set<String>> wiring = new HashMap<String, Set<String>>();

    BundleWires(Bundle bundle) {
        this.bundleId = bundle.getBundleId();
        for (BundleWire wire : ((BundleWiring)bundle.adapt(BundleWiring.class)).getRequiredWires(null)) {
            String requirementId = this.getRequirementId((Requirement)wire.getRequirement());
            String capabilityId = this.getCapabilityId(wire.getCapability());
            Set capabilityIds = this.wiring.computeIfAbsent(requirementId, key -> new HashSet());
            capabilityIds.add(capabilityId);
        }
    }

    BundleWires(long bundleId, BufferedReader reader) throws IOException {
        this.bundleId = bundleId;
        while (true) {
            String key = reader.readLine();
            String val = reader.readLine();
            if (key == null || val == null) break;
            Set capabilityIds = this.wiring.computeIfAbsent(key, k -> new HashSet());
            capabilityIds.add(val);
        }
    }

    void save(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Path file = path.resolve(Long.toString(this.bundleId));
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (BufferedWriter fw = Files.newBufferedWriter(file, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                for (Map.Entry<String, Set<String>> wires : this.wiring.entrySet()) {
                    String requirementId = wires.getKey();
                    Set<String> capabilityIds = wires.getValue();
                    for (String capabilityId : capabilityIds) {
                        fw.append(requirementId).append('\n');
                        fw.append(capabilityId).append('\n');
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void delete(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Path file = path.resolve(Long.toString(this.bundleId));
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    long[] getFragmentHosts() {
        return this.wiring.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("osgi.wiring.host")).map(Map.Entry::getValue).flatMap(Collection::stream).mapToLong(this::getBundleId).toArray();
    }

    private long getBundleId(String value) {
        int idx = value.indexOf(59);
        if (idx > 0) {
            value = value.substring(0, idx);
        }
        return Long.parseLong(value.trim());
    }

    Set<BundleCapability> filterCandidates(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        Set<String> wiredCapabilityIds = this.wiring.get(this.getRequirementId((Requirement)requirement));
        return candidates.stream().filter(capability -> this.isCapabilityWiredToBundle(wiredCapabilityIds, (BundleCapability)capability)).collect(Collectors.toSet());
    }

    private boolean isCapabilityWiredToBundle(Set<String> capabilityIds, BundleCapability capability) {
        return capabilityIds != null && capabilityIds.contains(this.getCapabilityId(capability)) || capabilityIds == null && capability.getRevision().getBundle().getBundleId() == this.bundleId;
    }

    private String getRequirementId(Requirement requirement) {
        String filter = (String)requirement.getDirectives().get("filter");
        if (filter != null) {
            return requirement.getNamespace() + "; " + filter;
        }
        return requirement.getNamespace();
    }

    private String getCapabilityId(BundleCapability capability) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(capability.getRevision().getBundle().getBundleId());
        Object v = capability.getAttributes().get("version");
        if (v != null) {
            sb.append("; version=").append(v.toString());
        }
        return sb.toString();
    }
}

