/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;

public abstract class QueueLoadBalancer
extends LoadBalancerSupport {
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        List<Processor> list = this.getProcessors();
        if (!list.isEmpty()) {
            Processor processor = this.chooseProcessor(list, exchange);
            if (processor == null) {
                IllegalStateException e = new IllegalStateException("No processors could be chosen to process " + exchange);
                exchange.setException(e);
            } else {
                if (processor instanceof AsyncProcessor) {
                    AsyncProcessor async = (AsyncProcessor)processor;
                    return async.process(exchange, callback);
                }
                try {
                    processor.process(exchange);
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
                callback.done(true);
                return true;
            }
        }
        callback.done(true);
        return true;
    }

    protected abstract Processor chooseProcessor(List<Processor> var1, Exchange var2);
}

