/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.server.HttpConnection;
import wiremock.org.eclipse.jetty.server.HttpInput;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.SharedBlockingCallback;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;

public class HttpInputOverHTTP
extends HttpInput<ByteBuffer>
implements Callback {
    private static final Logger LOG = Log.getLogger(HttpInputOverHTTP.class);
    private final SharedBlockingCallback _readBlocker = new SharedBlockingCallback();
    private final HttpConnection _httpConnection;
    private ByteBuffer _content;

    public HttpInputOverHTTP(HttpConnection httpConnection) {
        this._httpConnection = httpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        Object object = this.lock();
        synchronized (object) {
            super.recycle();
            this._content = null;
        }
    }

    @Override
    protected void blockForContent() throws IOException {
        Object content;
        do {
            try (SharedBlockingCallback.Blocker blocker = this._readBlocker.acquire();){
                this._httpConnection.fillInterested(blocker);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} block readable on {}", this, blocker);
                }
                blocker.block();
            }
        } while ((content = this.getNextContent()) == null && !this.isFinished());
    }

    @Override
    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    @Override
    protected ByteBuffer nextContent() throws IOException {
        if (BufferUtil.hasContent(this._content)) {
            return this._content;
        }
        this._content = null;
        this._httpConnection.parseContent();
        if (BufferUtil.hasContent(this._content)) {
            return this._content;
        }
        return null;
    }

    @Override
    protected int remaining(ByteBuffer item) {
        return item.remaining();
    }

    @Override
    protected int get(ByteBuffer item, byte[] buffer, int offset, int length) {
        int l = Math.min(item.remaining(), length);
        item.get(buffer, offset, l);
        return l;
    }

    @Override
    protected void consume(ByteBuffer item, int length) {
        item.position(item.position() + length);
    }

    @Override
    public void content(ByteBuffer item) {
        if (BufferUtil.hasContent(this._content)) {
            throw new IllegalStateException();
        }
        this._content = item;
    }

    @Override
    protected void unready() {
        this._httpConnection.fillInterested(this);
    }

    @Override
    public void succeeded() {
        this._httpConnection.getHttpChannel().getState().onReadPossible();
    }

    @Override
    public void failed(Throwable x) {
        super.failed(x);
        this._httpConnection.getHttpChannel().getState().onReadPossible();
    }
}

