/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.client.CallbackMetaData;
import org.apache.openejb.client.Injection;

public class ClientInjectionProcessor<T> {
    private static final Logger logger = Logger.getLogger("OpenEJB.client");
    private final Class<? extends T> beanClass;
    private final ClassLoader classLoader;
    private final List<Injection> injections;
    private final List<CallbackMetaData> postConstructCallbacks;
    private final List<CallbackMetaData> preDestroyCallbacks;
    private final Context context;
    private T instance;
    private boolean allowStatic;

    public ClientInjectionProcessor(Class<? extends T> beanClass, List<Injection> injections, List<CallbackMetaData> postConstructMethods, List<CallbackMetaData> preDestroyMethods, Context context) {
        this.beanClass = beanClass;
        this.classLoader = beanClass.getClassLoader();
        this.injections = injections;
        this.postConstructCallbacks = postConstructMethods;
        this.preDestroyCallbacks = preDestroyMethods;
        this.context = context;
    }

    public void allowStatic() {
        this.allowStatic = true;
    }

    public T createInstance() throws Exception {
        if (this.instance == null) {
            this.construct();
        }
        return this.instance;
    }

    public T getInstance() {
        return this.instance;
    }

    private void construct() {
        HashMap<Injection, Object> values = new HashMap<Injection, Object>();
        for (Injection injection : this.injections) {
            Class<? extends T> clazz = this.loadClass(injection.getTargetClass());
            if (clazz == null || !clazz.isAssignableFrom(this.beanClass)) continue;
            try {
                String jndiName = injection.getJndiName();
                Object object = this.context.lookup("java:comp/env/" + jndiName);
                values.put(injection, object);
            }
            catch (NamingException e) {
                logger.warning("Injection data not found in JNDI context: jndiName='" + injection.getJndiName() + "', target=" + injection.getTargetClass() + "/" + injection.getName());
            }
        }
        try {
            this.instance = this.beanClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while creating bean " + this.beanClass.getName(), e);
        }
        ArrayList<String> unsetProperties = new ArrayList<String>();
        for (Map.Entry entry : values.entrySet()) {
            Injection injection = (Injection)entry.getKey();
            Object value = entry.getValue();
            Class<? extends T> targetClass = this.loadClass(injection.getTargetClass());
            if (targetClass == null || !targetClass.isAssignableFrom(this.beanClass) || this.setProperty(targetClass, injection.getName(), value)) continue;
            unsetProperties.add(injection.getName());
        }
        if (unsetProperties.size() > 0) {
            for (Map.Entry entry : unsetProperties) {
                logger.warning("Injection: Unable to set property '" + String.valueOf(entry) + "' in class " + this.beanClass.getName());
            }
        }
    }

    public void postConstruct() throws Exception {
        if (this.instance == null) {
            throw new IllegalStateException("Instance has not been constructed");
        }
        if (this.postConstructCallbacks == null) {
            return;
        }
        for (Method postConstruct : this.toMethod(this.postConstructCallbacks)) {
            try {
                postConstruct.invoke(this.instance, new Object[0]);
            }
            catch (Exception e) {
                e = ClientInjectionProcessor.unwrap(e);
                throw new Exception("Error while calling post construct method", e);
            }
        }
    }

    public void preDestroy() {
        if (this.instance == null) {
            return;
        }
        if (this.preDestroyCallbacks == null) {
            return;
        }
        for (Method preDestroy : this.toMethod(this.preDestroyCallbacks)) {
            try {
                preDestroy.invoke(this.instance, new Object[0]);
            }
            catch (Exception e) {
                e = ClientInjectionProcessor.unwrap(e);
                logger.log(Level.SEVERE, "Error while calling pre destroy method", e);
            }
        }
    }

    private List<Method> toMethod(List<CallbackMetaData> callbacks) {
        ArrayList<String> methodsNotFound = new ArrayList<String>(1);
        ArrayList<Method> methods = new ArrayList<Method>(callbacks.size());
        for (CallbackMetaData callback : callbacks) {
            Method method = this.toMethod(callback);
            if (method != null) {
                methods.add(method);
                continue;
            }
            methodsNotFound.add(callback.toString());
        }
        if (!methodsNotFound.isEmpty()) {
            throw new IllegalStateException("Callback methods not found " + String.valueOf(methodsNotFound));
        }
        return methods;
    }

    private Method toMethod(CallbackMetaData callback) {
        try {
            String className = callback.getClassName();
            Class<?> clazz = this.classLoader.loadClass(className);
            return clazz.getDeclaredMethod(callback.getMethod(), new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean setProperty(Class clazz, String name, Object propertyValue) {
        Method method = this.findSetter(clazz, name, propertyValue);
        if (method != null) {
            try {
                propertyValue = this.convert(method.getParameterTypes()[0], propertyValue);
                method.invoke(this.instance, propertyValue);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        Field field = this.findField(clazz, name, propertyValue);
        if (field != null) {
            try {
                propertyValue = this.convert(field.getType(), propertyValue);
                field.set(this.instance, propertyValue);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public Method findSetter(Class typeClass, String propertyName, Object propertyValue) {
        if (propertyName == null) {
            throw new NullPointerException("name is null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.length() > 0) {
            setterName = setterName + propertyName.substring(1);
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(typeClass.getMethods()));
        methods.addAll(Arrays.asList(typeClass.getDeclaredMethods()));
        for (Method method : methods) {
            Class<?> methodParameterType;
            if (!method.getName().equals(setterName) || method.getParameterTypes().length == 0 || method.getParameterTypes().length > 1 || method.getReturnType() != Void.TYPE || Modifier.isAbstract(method.getModifiers()) || !this.allowStatic && Modifier.isStatic(method.getModifiers()) || (methodParameterType = method.getParameterTypes()[0]).isPrimitive() && propertyValue == null || !ClientInjectionProcessor.isInstance(methodParameterType, propertyValue) && !ClientInjectionProcessor.isConvertable(methodParameterType, propertyValue)) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                ClientInjectionProcessor.setAccessible(method);
            }
            return method;
        }
        return null;
    }

    public Field findField(Class typeClass, String propertyName, Object propertyValue) {
        if (propertyName == null) {
            throw new NullPointerException("name is null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(typeClass.getDeclaredFields()));
        for (Class parent = typeClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            fields.addAll(Arrays.asList(parent.getDeclaredFields()));
        }
        for (Field field : fields) {
            Class<?> fieldType;
            if (!field.getName().equals(propertyName) || !this.allowStatic && Modifier.isStatic(field.getModifiers()) || (fieldType = field.getType()).isPrimitive() && propertyValue == null || !ClientInjectionProcessor.isInstance(fieldType, propertyValue) && !ClientInjectionProcessor.isConvertable(fieldType, propertyValue)) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                ClientInjectionProcessor.setAccessible(field);
            }
            return field;
        }
        return null;
    }

    private static void setAccessible(final AccessibleObject accessibleObject) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                accessibleObject.setAccessible(true);
                return null;
            }
        });
    }

    private static boolean isInstance(Class type, Object instance) {
        if (type.isPrimitive()) {
            if (instance == null) {
                return false;
            }
            if (type.equals(Boolean.TYPE)) {
                return instance instanceof Boolean;
            }
            if (type.equals(Character.TYPE)) {
                return instance instanceof Character;
            }
            if (type.equals(Byte.TYPE)) {
                return instance instanceof Byte;
            }
            if (type.equals(Short.TYPE)) {
                return instance instanceof Short;
            }
            if (type.equals(Integer.TYPE)) {
                return instance instanceof Integer;
            }
            if (type.equals(Long.TYPE)) {
                return instance instanceof Long;
            }
            if (type.equals(Float.TYPE)) {
                return instance instanceof Float;
            }
            if (type.equals(Double.TYPE)) {
                return instance instanceof Double;
            }
            throw new AssertionError((Object)("Invalid primitve type: " + String.valueOf(type)));
        }
        return instance == null || type.isInstance(instance);
    }

    private static boolean isConvertable(Class type, Object propertyValue) {
        return propertyValue instanceof String && ClientInjectionProcessor.findEditor(type) != null;
    }

    private Object convert(Class type, Object value) {
        if (type == Object.class || !(value instanceof String)) {
            return value;
        }
        String stringValue = (String)value;
        PropertyEditor editor = ClientInjectionProcessor.findEditor(type);
        if (editor != null) {
            editor.setAsText(stringValue);
            value = editor.getValue();
        }
        return value;
    }

    private static PropertyEditor findEditor(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            return editor;
        }
        return null;
    }

    private Class<?> loadClass(String targetClass) {
        try {
            return this.classLoader.loadClass(targetClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Exception unwrap(Exception e) {
        if (e instanceof InvocationTargetException && e.getCause() instanceof Exception) {
            e = (Exception)e.getCause();
        }
        return e;
    }
}

