/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import jakarta.faces.application.ResourceVisitOption;
import jakarta.faces.context.FacesContext;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.myfaces.resource.ExternalContextResourceLoaderIterator;
import org.apache.myfaces.resource.ResourceLoader;
import org.apache.myfaces.resource.ResourceMeta;
import org.apache.myfaces.resource.ResourceMetaImpl;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.SkipMatchIterator;

public class RootExternalContextResourceLoader
extends ResourceLoader {
    private static final String CONTRACTS = "contracts";
    private static final String RESOURCES = "resources";
    private String contractsDirectory = null;
    private String resourcesDirectory = null;

    public RootExternalContextResourceLoader() {
        super("");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.contractsDirectory = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "jakarta.faces.WEBAPP_CONTRACTS_DIRECTORY", CONTRACTS);
        this.contractsDirectory = this.contractsDirectory.startsWith("/") ? this.contractsDirectory : "/" + this.contractsDirectory;
        this.resourcesDirectory = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "jakarta.faces.WEBAPP_RESOURCES_DIRECTORY", RESOURCES);
        this.resourcesDirectory = this.resourcesDirectory.startsWith("/") ? this.resourcesDirectory : "/" + this.resourcesDirectory;
    }

    protected Set<String> getResourcePaths(String path) {
        Object correctedPath = path.startsWith("/") ? path : "/" + path;
        return FacesContext.getCurrentInstance().getExternalContext().getResourcePaths((String)correctedPath);
    }

    @Override
    public String getResourceVersion(String path) {
        return null;
    }

    @Override
    public String getLibraryVersion(String path) {
        return null;
    }

    public URL getResourceURL(String resourceId) {
        try {
            Object correctedResourceId = resourceId.startsWith("/") ? resourceId : "/" + resourceId;
            return FacesContext.getCurrentInstance().getExternalContext().getResource((String)correctedResourceId);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URL getResourceURL(ResourceMeta resourceMeta) {
        if (resourceMeta.getLocalePrefix() != null) {
            return null;
        }
        return this.getResourceURL(resourceMeta.getResourceIdentifier());
    }

    @Override
    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        String resourceId = resourceMeta.getResourceIdentifier();
        Object correctedResourceId = resourceId.startsWith("/") ? resourceId : "/" + resourceId;
        return FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream((String)correctedResourceId);
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        return new ResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
    }

    @Override
    public boolean libraryExists(String libraryName) {
        return false;
    }

    @Override
    public Iterator<String> iterator(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        Object basePath = path;
        if (this.getPrefix() != null) {
            basePath = this.getPrefix() + "/" + (path.startsWith("/") ? path.substring(1) : path);
        }
        return new RootExternalContextResourceLoaderIterator(new ExternalContextResourceLoaderIterator(facesContext, (String)basePath, maxDepth, options), this.contractsDirectory, this.resourcesDirectory);
    }

    private static class RootExternalContextResourceLoaderIterator
    extends SkipMatchIterator<String> {
        private String contractsDirectory;
        private String resourcesDirectory;

        public RootExternalContextResourceLoaderIterator(Iterator delegate, String contractsDirectory, String resourcesDirectory) {
            super(delegate);
            this.contractsDirectory = contractsDirectory;
            this.resourcesDirectory = resourcesDirectory;
        }

        @Override
        protected boolean match(String instance) {
            return instance.startsWith(this.contractsDirectory) || instance.startsWith(this.resourcesDirectory);
        }
    }
}

