/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi.transactional;

import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.Transactional;
import jakarta.transaction.TransactionalException;
import java.rmi.RemoteException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.SystemException;
import org.apache.openejb.cdi.transactional.InterceptorBase;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TxNever;

@Interceptor
@Transactional(value=Transactional.TxType.NEVER)
@Priority(value=200)
public class NeverInterceptor
extends InterceptorBase {
    @Override
    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        try {
            return super.intercept(ic);
        }
        catch (RemoteException re) {
            throw new TransactionalException(re.getMessage(), (Throwable)new InvalidTransactionException(re.getMessage()));
        }
    }

    @Override
    protected TransactionPolicy getPolicy() throws SystemException, ApplicationException {
        return new TxNever(NeverInterceptor.getTransactionManager());
    }

    @Override
    protected boolean doesForbidUtUsage() {
        return false;
    }
}

