/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre19Compat;
import org.apache.tomcat.util.res.StringManager;

public class Jre20Compat
extends Jre19Compat {
    private static final Log log = LogFactory.getLog(Jre20Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre20Compat.class);
    private static final boolean supported;
    private static final Method setNamedGroupsMethod;

    static boolean isSupported() {
        return supported;
    }

    @Override
    public void setNamedGroupsMethod(Object sslParameters, String[] names) {
        try {
            setNamedGroupsMethod.invoke(sslParameters, new Object[]{names});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        Class<?> c1 = null;
        Method m1 = null;
        try {
            c1 = Class.forName("javax.net.ssl.SSLParameters");
            m1 = c1.getMethod("setNamedGroups", String[].class);
        }
        catch (NoSuchMethodException e) {
            log.debug(sm.getString("jre20Compat.javaPre20"), e);
        }
        catch (ReflectiveOperationException e) {
            log.error(sm.getString("jre20Compat.unexpected"), e);
        }
        supported = m1 != null;
        setNamedGroupsMethod = m1;
    }
}

