/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.GValueConstantTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GValue<V>
implements Serializable,
Cloneable {
    private final String name;
    private final V value;

    private GValue(V value) {
        this(null, value);
    }

    private GValue(String name, V value) {
        if (name != null && name.startsWith("_")) {
            throw new IllegalArgumentException(String.format("Invalid GValue name [%s]. Should not start with _.", name));
        }
        if (value instanceof GValue) {
            throw new IllegalArgumentException("GValues cannot be nested");
        }
        this.name = name;
        this.value = value;
    }

    public boolean isVariable() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public V get() {
        return this.value;
    }

    public String toString() {
        return this.isVariable() ? String.format("%s=%s", this.name, this.value) : Objects.toString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GValue gValue = (GValue)o;
        return Objects.equals(this.name, gValue.name) && Objects.equals(this.value, gValue.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public GValue<V> clone() {
        if (this.value == null) {
            return new GValue<Object>(this.name, null);
        }
        if (this.value instanceof Serializable) {
            try {
                return new GValue<Serializable>(this.name, SerializationUtils.clone((Serializable)((Serializable)this.value)));
            }
            catch (SerializationException e) {
                return new GValue<V>(this.name, this.value);
            }
        }
        return new GValue<V>(this.name, this.value);
    }

    public static <V> GValue<V> of(V value) {
        if (value instanceof GValue) {
            return (GValue)value;
        }
        return new GValue<V>(value);
    }

    public static <V> GValue<V> of(String name, V value) {
        if (value instanceof GValue) {
            throw new IllegalArgumentException("value cannot be a GValue");
        }
        return new GValue<V>(name, value);
    }

    public static GValue<String> ofString(String value) {
        return new GValue<String>(value);
    }

    public static GValue<String> ofString(String name, String value) {
        return new GValue<String>(name, value);
    }

    public static GValue<Integer> ofInteger(Integer value) {
        return new GValue<Integer>(value);
    }

    public static GValue<Integer> ofInteger(String name, Integer value) {
        return new GValue<Integer>(name, value);
    }

    public static GValue<Boolean> ofBoolean(Boolean value) {
        return new GValue<Boolean>(value);
    }

    public static GValue<Boolean> ofBoolean(String name, Boolean value) {
        return new GValue<Boolean>(name, value);
    }

    public static GValue<Double> ofDouble(Double value) {
        return new GValue<Double>(value);
    }

    public static GValue<Double> ofDouble(String name, Double value) {
        return new GValue<Double>(name, value);
    }

    public static GValue<BigInteger> ofBigInteger(BigInteger value) {
        return new GValue<BigInteger>(value);
    }

    public static GValue<BigInteger> ofBigInteger(String name, BigInteger value) {
        return new GValue<BigInteger>(name, value);
    }

    public static GValue<BigDecimal> ofBigDecimal(BigDecimal value) {
        return new GValue<BigDecimal>(value);
    }

    public static GValue<BigDecimal> ofBigDecimal(String name, BigDecimal value) {
        return new GValue<BigDecimal>(name, value);
    }

    public static GValue<Long> ofLong(Long value) {
        return new GValue<Long>(value);
    }

    public static GValue<Long> ofLong(String name, Long value) {
        return new GValue<Long>(name, value);
    }

    public static GValue<Map> ofMap(Map value) {
        return new GValue<Map>(value);
    }

    public static GValue<Map<?, ?>> ofMap(String name, Map value) {
        return new GValue(name, value);
    }

    public static <T> GValue<List<T>> ofList(List<T> value) {
        return new GValue<List<T>>(value);
    }

    public static <T> GValue<List<T>> ofList(String name, List<T> value) {
        return new GValue<List<T>>(name, value);
    }

    public static GValue<Set> ofSet(Set value) {
        return new GValue<Set>(value);
    }

    public static GValue<Set> ofSet(String name, Set value) {
        return new GValue<Set>(name, value);
    }

    public static GValue<Vertex> ofVertex(Vertex value) {
        return new GValue<Vertex>(value);
    }

    public static GValue<Vertex> ofVertex(String name, Vertex value) {
        return new GValue<Vertex>(name, value);
    }

    public static <T> T getFrom(Object o) {
        return (T)(o instanceof GValue ? ((GValue)o).get() : o);
    }

    public static boolean valueInstanceOf(Object o, Class<?> type) {
        return o instanceof GValue && !((GValue)o).isNull() && type.isAssignableFrom(((GValue)o).get().getClass());
    }

    public static <T> GValue<T>[] ensureGValues(Object[] args) {
        return (GValue[])Stream.of(args).map(GValue::of).toArray(GValue[]::new);
    }

    public static Object[] resolveToValues(GValue<?>[] gvalues) {
        Object[] values = new Object[gvalues.length];
        for (int i = 0; i < gvalues.length; ++i) {
            values[i] = gvalues[i].get();
        }
        return values;
    }

    public static boolean containsGValues(Object ... args) {
        for (Object arg : args) {
            if (!(arg instanceof GValue)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsVariables(Object ... args) {
        for (Object arg : args) {
            if (arg instanceof GValue && ((GValue)arg).isVariable()) {
                return true;
            }
            if (!(arg instanceof GValueConstantTraversal) || !((GValueConstantTraversal)arg).isParameterized()) continue;
            return true;
        }
        return false;
    }

    public static Object valueOf(Object either) {
        if (either instanceof GValue) {
            return ((GValue)either).get();
        }
        return either;
    }
}

