/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.speculation.legacy;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.speculation.legacy.DataStatistics;
import org.apache.tez.dag.app.dag.speculation.legacy.TaskRuntimeEstimator;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;

abstract class StartEndTimesBase
implements TaskRuntimeEstimator {
    static final float MINIMUM_COMPLETE_PROPORTION_TO_SPECULATE = 0.05f;
    static final int MINIMUM_COMPLETE_NUMBER_TO_SPECULATE = 1;
    protected Vertex vertex;
    protected final Map<TezTaskAttemptID, Long> startTimes = new ConcurrentHashMap<TezTaskAttemptID, Long>();
    protected final DataStatistics taskStatistics = new DataStatistics();
    private float slowTaskRelativeThresholds;
    protected final Set<Task> doneTasks = new HashSet<Task>();

    StartEndTimesBase() {
    }

    @Override
    public void enrollAttempt(TezTaskAttemptID id, long timestamp) {
        this.startTimes.put(id, timestamp);
    }

    @Override
    public long attemptEnrolledTime(TezTaskAttemptID attemptID) {
        Long result = this.startTimes.get(attemptID);
        return result == null ? Long.MAX_VALUE : result;
    }

    @Override
    public void contextualize(Configuration conf, Vertex vertexP) {
        this.slowTaskRelativeThresholds = conf.getFloat("tez.am.legacy.speculative.slowtask.threshold", 1.0f);
        this.vertex = vertexP;
    }

    protected DataStatistics dataStatisticsForTask(TezTaskID taskID) {
        return this.taskStatistics;
    }

    @Override
    public long thresholdRuntime(TezTaskID taskID) {
        int completedTasks = this.vertex.getCompletedTasks();
        int totalTasks = this.vertex.getTotalTasks();
        if (completedTasks < 1 || (float)completedTasks / (float)totalTasks < 0.05f) {
            return Long.MAX_VALUE;
        }
        long result = (long)this.taskStatistics.outlier(this.slowTaskRelativeThresholds);
        return result;
    }

    @Override
    public long newAttemptEstimatedRuntime() {
        return (long)this.taskStatistics.mean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttempt(TezTaskAttemptID attemptID, TaskAttemptState state, long timestamp) {
        Task task = this.vertex.getTask(attemptID.getTaskID());
        if (task == null) {
            return;
        }
        Long boxedStart = this.startTimes.get(attemptID);
        long start = boxedStart == null ? Long.MIN_VALUE : boxedStart;
        TaskAttempt taskAttempt = task.getAttempt(attemptID);
        if (taskAttempt.getState() == TaskAttemptState.SUCCEEDED) {
            boolean isNew = false;
            Set<Task> set = this.doneTasks;
            synchronized (set) {
                if (!this.doneTasks.contains(task)) {
                    this.doneTasks.add(task);
                    isNew = true;
                }
            }
            if (isNew) {
                long finish = timestamp;
                if (start > 1L && finish > 1L && start <= finish) {
                    long duration = finish - start;
                    this.taskStatistics.add(duration);
                }
            }
        }
    }
}

