/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTaskSchedulerService
extends TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTaskSchedulerService.class);
    final ContainerSignatureMatcher containerSignatureMatcher;
    final LinkedBlockingQueue<SchedulerRequest> taskRequestQueue = new LinkedBlockingQueue();
    final Configuration conf;
    AsyncDelegateRequestHandler taskRequestHandler;
    Thread asyncDelegateRequestThread;
    final HashMap<Object, AllocatedTask> taskAllocations = new LinkedHashMap<Object, AllocatedTask>();
    final String appTrackingUrl;
    final long customContainerAppId;

    public LocalTaskSchedulerService(TaskSchedulerContext taskSchedulerContext) {
        super(taskSchedulerContext);
        this.appTrackingUrl = taskSchedulerContext.getAppTrackingUrl();
        this.containerSignatureMatcher = taskSchedulerContext.getContainerSignatureMatcher();
        this.customContainerAppId = taskSchedulerContext.getCustomClusterIdentifier();
        try {
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)taskSchedulerContext.getInitialUserPayload());
        }
        catch (IOException e) {
            throw new TezUncheckedException("Failed to deserialize payload for " + LocalTaskSchedulerService.class.getSimpleName(), (Throwable)e);
        }
    }

    public Resource getAvailableResources() {
        long memory = Runtime.getRuntime().freeMemory();
        int cores = Runtime.getRuntime().availableProcessors();
        return LocalTaskSchedulerService.createResource(memory, cores);
    }

    static Resource createResource(long runtimeMemory, int core) {
        if (runtimeMemory < 0L || core < 0) {
            throw new IllegalArgumentException("Negative Memory or Core provided!mem: " + runtimeMemory + " core:" + core);
        }
        return Resource.newInstance((int)Ints.checkedCast((long)(runtimeMemory / 0x100000L)), (int)core);
    }

    public int getClusterNodeCount() {
        return 1;
    }

    public void dagComplete() {
        this.taskRequestHandler.dagComplete();
    }

    public Resource getTotalResources() {
        long memory = Runtime.getRuntime().maxMemory();
        int cores = Runtime.getRuntime().availableProcessors();
        return LocalTaskSchedulerService.createResource(memory, cores);
    }

    public void blacklistNode(NodeId nodeId) {
    }

    public void unblacklistNode(NodeId nodeId) {
    }

    public void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) {
        this.taskRequestHandler.addAllocateTaskRequest(task, capability, priority, clientCookie);
    }

    public synchronized void allocateTask(Object task, Resource capability, ContainerId containerId, Priority priority, Object containerSignature, Object clientCookie) {
        this.taskRequestHandler.addAllocateTaskRequest(task, capability, priority, clientCookie);
    }

    public boolean deallocateTask(Object task, boolean taskSucceeded, TaskAttemptEndReason endReason, String diagnostics) {
        return this.taskRequestHandler.addDeallocateTaskRequest(task);
    }

    public Object deallocateContainer(ContainerId containerId) {
        this.taskRequestHandler.addDeallocateContainerRequest(containerId);
        return null;
    }

    public void initialize() {
        this.taskRequestHandler = this.createRequestHandler(this.conf);
        this.asyncDelegateRequestThread = new Thread(this.taskRequestHandler);
        this.asyncDelegateRequestThread.setName(LocalTaskSchedulerService.class.getSimpleName() + "RequestHandler");
        this.asyncDelegateRequestThread.setDaemon(true);
    }

    protected AsyncDelegateRequestHandler createRequestHandler(Configuration conf) {
        return new AsyncDelegateRequestHandler(this.taskRequestQueue, new LocalContainerFactory(this.getContext().getApplicationAttemptId(), this.customContainerAppId), this.taskAllocations, this.getContext(), conf);
    }

    public void start() {
        this.asyncDelegateRequestThread.start();
    }

    public void shutdown() throws InterruptedException {
        if (this.asyncDelegateRequestThread != null) {
            this.asyncDelegateRequestThread.interrupt();
        }
    }

    public void setShouldUnregister() {
    }

    public boolean hasUnregistered() {
        return true;
    }

    public void initiateStop() {
    }

    public int getHeldContainersCount() {
        return 0;
    }

    static class AsyncDelegateRequestHandler
    implements Runnable {
        final LinkedBlockingQueue<SchedulerRequest> clientRequestQueue;
        final PriorityBlockingQueue<AllocateTaskRequest> taskRequestQueue;
        final LocalContainerFactory localContainerFactory;
        final HashMap<Object, AllocatedTask> taskAllocations;
        final TaskSchedulerContext taskSchedulerContext;
        private final Object descendantsLock = new Object();
        private ArrayList<BitSet> vertexDescendants = null;
        final int MAX_TASKS;

        AsyncDelegateRequestHandler(LinkedBlockingQueue<SchedulerRequest> clientRequestQueue, LocalContainerFactory localContainerFactory, HashMap<Object, AllocatedTask> taskAllocations, TaskSchedulerContext taskSchedulerContext, Configuration conf) {
            this.clientRequestQueue = clientRequestQueue;
            this.localContainerFactory = localContainerFactory;
            this.taskAllocations = taskAllocations;
            this.taskSchedulerContext = taskSchedulerContext;
            this.MAX_TASKS = conf.getInt("tez.am.inline.task.execution.max-tasks", 1);
            this.taskRequestQueue = new PriorityBlockingQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dagComplete() {
            Object object = this.descendantsLock;
            synchronized (object) {
                this.vertexDescendants = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureVertexDescendants() {
            Object object = this.descendantsLock;
            synchronized (object) {
                if (this.vertexDescendants == null) {
                    DagInfo info = this.taskSchedulerContext.getCurrentDagInfo();
                    if (info == null) {
                        throw new IllegalStateException("Scheduling tasks but no current DAG info?");
                    }
                    int numVertices = info.getTotalVertices();
                    ArrayList<BitSet> descendants = new ArrayList<BitSet>(numVertices);
                    for (int i = 0; i < numVertices; ++i) {
                        descendants.add(info.getVertexDescendants(i));
                    }
                    this.vertexDescendants = descendants;
                }
            }
        }

        public void addAllocateTaskRequest(Object task, Resource capability, Priority priority, Object clientCookie) {
            try {
                int vertexIndex = this.taskSchedulerContext.getVertexIndexForTask(task);
                this.clientRequestQueue.put(new AllocateTaskRequest(task, vertexIndex, capability, priority, clientCookie));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public boolean addDeallocateTaskRequest(Object task) {
            try {
                this.clientRequestQueue.put(new DeallocateTaskRequest(task));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        }

        public void addDeallocateContainerRequest(ContainerId containerId) {
            try {
                this.clientRequestQueue.put(new DeallocateContainerRequest(containerId));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        boolean shouldProcess() {
            return !this.taskRequestQueue.isEmpty() && this.taskAllocations.size() < this.MAX_TASKS;
        }

        boolean shouldPreempt() {
            return !this.taskRequestQueue.isEmpty() && this.taskAllocations.size() >= this.MAX_TASKS;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                this.dispatchRequest();
                while (this.shouldProcess()) {
                    this.allocateTask();
                }
            }
        }

        void dispatchRequest() {
            try {
                SchedulerRequest request = this.clientRequestQueue.take();
                if (request instanceof AllocateTaskRequest) {
                    this.taskRequestQueue.put((AllocateTaskRequest)request);
                    if (this.shouldPreempt()) {
                        this.maybePreempt((AllocateTaskRequest)request);
                    }
                } else if (request instanceof DeallocateTaskRequest) {
                    this.deallocateTask((DeallocateTaskRequest)request);
                } else if (request instanceof DeallocateContainerRequest) {
                    this.preemptTask((DeallocateContainerRequest)request);
                } else {
                    LOG.error("Unknown task request message: " + request);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        void maybePreempt(AllocateTaskRequest request) {
            Priority priority = request.priority;
            for (Map.Entry<Object, AllocatedTask> entry : this.taskAllocations.entrySet()) {
                AllocatedTask allocatedTask = entry.getValue();
                Container container = allocatedTask.container;
                if (priority.compareTo(allocatedTask.container.getPriority()) <= 0) continue;
                Object task = entry.getKey();
                this.ensureVertexDescendants();
                if (!this.vertexDescendants.get(request.vertexIndex).get(allocatedTask.request.vertexIndex)) continue;
                LOG.info("Preempting task/container for task/priority:" + task + "/" + container + " for " + request.task + "/" + priority);
                this.taskSchedulerContext.preemptContainer(allocatedTask.container.getId());
            }
        }

        void allocateTask() {
            try {
                AllocateTaskRequest request = this.taskRequestQueue.take();
                Container container = this.localContainerFactory.createContainer(request.capability, request.priority);
                this.taskAllocations.put(request.task, new AllocatedTask(request, container));
                this.taskSchedulerContext.taskAllocated(request.task, request.clientCookie, container);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        void deallocateTask(DeallocateTaskRequest request) {
            AllocatedTask allocatedTask = this.taskAllocations.remove(request.task);
            if (allocatedTask != null) {
                this.taskSchedulerContext.containerBeingReleased(allocatedTask.container.getId());
            } else {
                Iterator<AllocateTaskRequest> iter = this.taskRequestQueue.iterator();
                while (iter.hasNext()) {
                    TaskRequest taskRequest = iter.next();
                    if (!taskRequest.task.equals(request.task)) continue;
                    iter.remove();
                    LOG.info("Deallocation request before allocation for task:" + request.task);
                    break;
                }
            }
        }

        void preemptTask(DeallocateContainerRequest request) {
            LOG.info("Trying to preempt: " + request.containerId);
            Iterator<Map.Entry<Object, AllocatedTask>> entries = this.taskAllocations.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<Object, AllocatedTask> entry = entries.next();
                Container container = entry.getValue().container;
                if (!container.getId().equals((Object)request.containerId)) continue;
                entries.remove();
                Object task = entry.getKey();
                LOG.info("Preempting task/container:" + task + "/" + container);
                this.taskSchedulerContext.containerBeingReleased(container.getId());
            }
        }
    }

    static class AllocatedTask {
        final AllocateTaskRequest request;
        final Container container;

        AllocatedTask(AllocateTaskRequest request, Container container) {
            this.request = request;
            this.container = container;
        }
    }

    static class DeallocateContainerRequest
    extends SchedulerRequest {
        final ContainerId containerId;

        public DeallocateContainerRequest(ContainerId containerId) {
            this.containerId = containerId;
        }
    }

    static class DeallocateTaskRequest
    extends TaskRequest {
        public DeallocateTaskRequest(Object task) {
            super(task);
        }
    }

    static class AllocateTaskRequest
    extends TaskRequest
    implements Comparable<AllocateTaskRequest> {
        final Priority priority;
        final Resource capability;
        final Object clientCookie;
        final int vertexIndex;

        public AllocateTaskRequest(Object task, int vertexIndex, Resource capability, Priority priority, Object clientCookie) {
            super(task);
            this.priority = priority;
            this.capability = capability;
            this.clientCookie = clientCookie;
            this.vertexIndex = vertexIndex;
        }

        @Override
        public int compareTo(AllocateTaskRequest request) {
            return request.priority.compareTo(this.priority);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AllocateTaskRequest that = (AllocateTaskRequest)o;
            if (this.priority != null ? !this.priority.equals((Object)that.priority) : that.priority != null) {
                return false;
            }
            if (this.capability != null ? !this.capability.equals((Object)that.capability) : that.capability != null) {
                return false;
            }
            return !(this.clientCookie != null ? !this.clientCookie.equals(that.clientCookie) : that.clientCookie != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 12329 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 12329 * result + (this.capability != null ? this.capability.hashCode() : 0);
            result = 12329 * result + (this.clientCookie != null ? this.clientCookie.hashCode() : 0);
            return result;
        }
    }

    static class TaskRequest
    extends SchedulerRequest {
        final Object task;

        public TaskRequest(Object task) {
            this.task = task;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskRequest that = (TaskRequest)o;
            return !(this.task != null ? !this.task.equals(that.task) : that.task != null);
        }

        public int hashCode() {
            return 7841 + (this.task != null ? this.task.hashCode() : 0);
        }
    }

    static class SchedulerRequest {
        SchedulerRequest() {
        }
    }

    static class LocalContainerFactory {
        AtomicInteger nextId = new AtomicInteger(1);
        final ApplicationAttemptId customAppAttemptId;

        public LocalContainerFactory(ApplicationAttemptId appAttemptId, long customAppId) {
            ApplicationId appId = ApplicationId.newInstance((long)customAppId, (int)appAttemptId.getApplicationId().getId());
            this.customAppAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)appAttemptId.getAttemptId());
        }

        public Container createContainer(Resource capability, Priority priority) {
            ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)this.customAppAttemptId, (int)this.nextId.getAndIncrement());
            NodeId nodeId = NodeId.newInstance((String)"127.0.0.1", (int)0);
            String nodeHttpAddress = "127.0.0.1:0";
            Container container = Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)nodeHttpAddress, (Resource)capability, (Priority)priority, null);
            return container;
        }
    }
}

