/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezExecutors;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;

public abstract class TezTaskContextImpl
implements TaskContext,
Closeable {
    private static final AtomicInteger ID_GEN = new AtomicInteger(10000);
    protected final String taskVertexName;
    protected final TezTaskAttemptID taskAttemptID;
    private final TezCounters counters;
    private Configuration configuration;
    private String[] workDirs;
    private String uniqueIdentifier;
    protected final LogicalIOProcessorRuntimeTask runtimeTask;
    protected final TezUmbilical tezUmbilical;
    private final Map<String, ByteBuffer> serviceConsumerMetadata;
    private final int appAttemptNumber;
    private final Map<String, String> auxServiceEnv;
    protected volatile MemoryDistributor initialMemoryDistributor;
    protected final EntityDescriptor<?> descriptor;
    private final String dagName;
    private volatile ObjectRegistry objectRegistry;
    private final int vertexParallelism;
    private final ExecutionContext ExecutionContext;
    private final long memAvailable;
    private final TezExecutors sharedExecutor;

    @InterfaceAudience.Private
    public TezTaskContextImpl(Configuration conf, String[] workDirs, int appAttemptNumber, String dagName, String taskVertexName, int vertexParallelism, TezTaskAttemptID taskAttemptID, TezCounters counters, LogicalIOProcessorRuntimeTask runtimeTask, TezUmbilical tezUmbilical, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv, MemoryDistributor memDist, EntityDescriptor<?> descriptor, ObjectRegistry objectRegistry, ExecutionContext ExecutionContext2, long memAvailable, TezExecutors sharedExecutor) {
        Objects.requireNonNull(conf, "conf is null");
        Objects.requireNonNull(dagName, "dagName is null");
        Objects.requireNonNull(taskVertexName, "taskVertexName is null");
        Objects.requireNonNull(taskAttemptID, "taskAttemptId is null");
        Objects.requireNonNull(counters, "counters is null");
        Objects.requireNonNull(runtimeTask, "runtimeTask is null");
        Objects.requireNonNull(auxServiceEnv, "auxServiceEnv is null");
        Objects.requireNonNull(memDist, "memDist is null");
        Objects.requireNonNull(descriptor, "descriptor is null");
        Objects.requireNonNull(sharedExecutor, "sharedExecutor is null");
        this.dagName = dagName;
        this.configuration = conf;
        this.taskVertexName = taskVertexName;
        this.taskAttemptID = taskAttemptID;
        this.counters = counters;
        this.workDirs = workDirs;
        this.runtimeTask = runtimeTask;
        this.tezUmbilical = tezUmbilical;
        this.serviceConsumerMetadata = serviceConsumerMetadata;
        this.appAttemptNumber = appAttemptNumber;
        this.auxServiceEnv = auxServiceEnv;
        this.uniqueIdentifier = String.format("%s_%05d", taskAttemptID.toString(), this.generateId());
        this.initialMemoryDistributor = memDist;
        this.descriptor = descriptor;
        this.objectRegistry = objectRegistry;
        this.vertexParallelism = vertexParallelism;
        this.ExecutionContext = ExecutionContext2;
        this.memAvailable = memAvailable;
        this.sharedExecutor = sharedExecutor;
    }

    public ApplicationId getApplicationId() {
        return this.taskAttemptID.getApplicationId();
    }

    public int getTaskIndex() {
        return this.taskAttemptID.getTaskID().getId();
    }

    public int getDAGAttemptNumber() {
        return this.appAttemptNumber;
    }

    public int getTaskAttemptNumber() {
        return this.taskAttemptID.getId();
    }

    public Configuration getContainerConfiguration() {
        return this.configuration;
    }

    public String getDAGName() {
        return this.dagName;
    }

    public String getTaskVertexName() {
        return this.taskVertexName;
    }

    public int getTaskVertexIndex() {
        return this.taskAttemptID.getVertexID().getId();
    }

    public int getDagIdentifier() {
        return this.taskAttemptID.getDAGID().getId();
    }

    public TezCounters getCounters() {
        return this.counters;
    }

    public int getVertexParallelism() {
        return this.vertexParallelism;
    }

    public String[] getWorkDirs() {
        return Arrays.copyOf(this.workDirs, this.workDirs.length);
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public ObjectRegistry getObjectRegistry() {
        return this.objectRegistry;
    }

    public final void notifyProgress() {
        this.runtimeTask.notifyProgressInvocation();
    }

    public ByteBuffer getServiceConsumerMetaData(String serviceName) {
        return (ByteBuffer)this.serviceConsumerMetadata.get(serviceName).asReadOnlyBuffer().rewind();
    }

    @Nullable
    public ByteBuffer getServiceProviderMetaData(String serviceName) {
        Objects.requireNonNull(serviceName, "serviceName is null");
        return AuxiliaryServiceHelper.getServiceDataFromEnv((String)serviceName, this.auxServiceEnv);
    }

    public void requestInitialMemory(long size, MemoryUpdateCallback callbackHandler) {
        if (callbackHandler == null) {
            Preconditions.checkArgument((size == 0L ? 1 : 0) != 0, (Object)"A Null callback handler can only be used with a request size of 0");
            callbackHandler = new MemoryUpdateCallback(){

                public void memoryAssigned(long assignedSize) {
                }
            };
        }
        this.initialMemoryDistributor.requestMemory(size, callbackHandler, this, this.descriptor);
    }

    public long getTotalMemoryAvailableToTask() {
        return this.memAvailable;
    }

    protected void signalFatalError(Throwable t, String message, EventMetaData sourceInfo) {
        this.signalFailure(TaskFailureType.NON_FATAL, t, message, sourceInfo);
    }

    protected void signalFailure(TaskFailureType taskFailureType, Throwable t, String message, EventMetaData sourceInfo) {
        Objects.requireNonNull(taskFailureType, "TaskFailureType must be specified");
        this.runtimeTask.setFrameworkCounters();
        this.runtimeTask.registerError();
        this.tezUmbilical.signalFailure(this.taskAttemptID, taskFailureType, t, message, sourceInfo);
    }

    protected void signalKillSelf(Throwable t, String message, EventMetaData sourceInfo) {
        this.runtimeTask.setFrameworkCounters();
        this.runtimeTask.registerError();
        this.tezUmbilical.signalKillSelf(this.taskAttemptID, t, message, sourceInfo);
    }

    public ExecutionContext getExecutionContext() {
        return this.ExecutionContext;
    }

    public ExecutorService createTezFrameworkExecutorService(int parallelism, String threadNameFormat) {
        return this.sharedExecutor.createExecutorService(parallelism, threadNameFormat);
    }

    private int generateId() {
        return ID_GEN.incrementAndGet();
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((boolean)this.runtimeTask.isTaskDone(), (Object)"Runtime task must be complete before calling cleanup");
        this.objectRegistry = null;
        this.initialMemoryDistributor = null;
    }
}

