/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.util.Timer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.Realm;
import org.asynchttpclient.SslEngineFactory;
import org.asynchttpclient.channel.ChannelPool;
import org.asynchttpclient.channel.KeepAliveStrategy;
import org.asynchttpclient.cookie.CookieStore;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.netty.EagerResponseBodyPart;
import org.asynchttpclient.netty.LazyResponseBodyPart;
import org.asynchttpclient.netty.channel.ConnectionSemaphoreFactory;
import org.asynchttpclient.proxy.ProxyServerSelector;

public interface AsyncHttpClientConfig {
    public String getAhcVersion();

    public String getThreadPoolName();

    public int getMaxConnections();

    public int getMaxConnectionsPerHost();

    public int getAcquireFreeChannelTimeout();

    public int getConnectTimeout();

    public int getReadTimeout();

    public int getPooledConnectionIdleTimeout();

    public int getConnectionPoolCleanerPeriod();

    public int getRequestTimeout();

    public boolean isFollowRedirect();

    public int getMaxRedirects();

    public boolean isKeepAlive();

    public String getUserAgent();

    public boolean isCompressionEnforced();

    public ThreadFactory getThreadFactory();

    public ProxyServerSelector getProxyServerSelector();

    public SslContext getSslContext();

    public Realm getRealm();

    public List<RequestFilter> getRequestFilters();

    public List<ResponseFilter> getResponseFilters();

    public List<IOExceptionFilter> getIoExceptionFilters();

    public CookieStore getCookieStore();

    public int expiredCookieEvictionDelay();

    public int getMaxRequestRetry();

    public boolean isDisableUrlEncodingForBoundRequests();

    public boolean isUseLaxCookieEncoder();

    public boolean isStrict302Handling();

    public int getConnectionTtl();

    public boolean isUseOpenSsl();

    public boolean isUseInsecureTrustManager();

    public boolean isDisableHttpsEndpointIdentificationAlgorithm();

    public String[] getEnabledProtocols();

    public String[] getEnabledCipherSuites();

    public boolean isFilterInsecureCipherSuites();

    public int getSslSessionCacheSize();

    public int getSslSessionTimeout();

    public int getHttpClientCodecMaxInitialLineLength();

    public int getHttpClientCodecMaxHeaderSize();

    public int getHttpClientCodecMaxChunkSize();

    public int getHttpClientCodecInitialBufferSize();

    public boolean isDisableZeroCopy();

    public int getHandshakeTimeout();

    public SslEngineFactory getSslEngineFactory();

    public int getChunkedFileChunkSize();

    public int getWebSocketMaxBufferSize();

    public int getWebSocketMaxFrameSize();

    public boolean isKeepEncodingHeader();

    public int getShutdownQuietPeriod();

    public int getShutdownTimeout();

    public Map<ChannelOption<Object>, Object> getChannelOptions();

    public EventLoopGroup getEventLoopGroup();

    public boolean isUseNativeTransport();

    public Consumer<Channel> getHttpAdditionalChannelInitializer();

    public Consumer<Channel> getWsAdditionalChannelInitializer();

    public ResponseBodyPartFactory getResponseBodyPartFactory();

    public ChannelPool getChannelPool();

    public ConnectionSemaphoreFactory getConnectionSemaphoreFactory();

    public Timer getNettyTimer();

    public long getHashedWheelTimerTickDuration();

    public int getHashedWheelTimerSize();

    public KeepAliveStrategy getKeepAliveStrategy();

    public boolean isValidateResponseHeaders();

    public boolean isAggregateWebSocketFrameFragments();

    public boolean isEnableWebSocketCompression();

    public boolean isTcpNoDelay();

    public boolean isSoReuseAddress();

    public boolean isSoKeepAlive();

    public int getSoLinger();

    public int getSoSndBuf();

    public int getSoRcvBuf();

    public ByteBufAllocator getAllocator();

    public int getIoThreadsCount();

    public static enum ResponseBodyPartFactory {
        EAGER{

            @Override
            public HttpResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
                return new EagerResponseBodyPart(buf, last);
            }
        }
        ,
        LAZY{

            @Override
            public HttpResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
                return new LazyResponseBodyPart(buf, last);
            }
        };


        public abstract HttpResponseBodyPart newResponseBodyPart(ByteBuf var1, boolean var2);
    }
}

