/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import java.util.ArrayList;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class Binary
extends Lop {
    private Types.OpOp2 operation;
    private final int _numThreads;
    private final boolean inplace;

    public Binary(Lop input1, Lop input2, Types.OpOp2 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this(input1, input2, op, dt, vt, et, 1);
    }

    public Binary(Lop input1, Lop input2, Types.OpOp2 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int k) {
        this(input1, input2, op, dt, vt, et, k, false);
    }

    public Binary(Lop input1, Lop input2, Types.OpOp2 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int k, boolean inplace) {
        super(Lop.Type.Binary, dt, vt);
        this.init(input1, input2, op, dt, vt, et);
        this._numThreads = k;
        this.inplace = inplace;
    }

    private void init(Lop input1, Lop input2, Types.OpOp2 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this.operation = op;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return " Operation: " + this.operation;
    }

    @Override
    public Lop getBroadcastInput() {
        if (this.getExecType() != Types.ExecType.SPARK) {
            return null;
        }
        ArrayList<Lop> inputs = this.getInputs();
        if (inputs.get(0).getDataType() == Types.DataType.FRAME && inputs.get(1).getDataType() == Types.DataType.MATRIX) {
            return inputs.get(1);
        }
        return null;
    }

    public Types.OpOp2 getOperationType() {
        return this.operation;
    }

    private String getOpcode() {
        return this.operation.toString();
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        String ret = InstructionUtils.concatOperands(this.getExecType().name(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output));
        if (this.getExecType() == Types.ExecType.CP) {
            ret = InstructionUtils.concatOperands(ret, String.valueOf(this._numThreads));
        } else if (this.getExecType() == Types.ExecType.FED) {
            ret = InstructionUtils.concatOperands(ret, String.valueOf(this._numThreads), this._fedOutput.name());
        }
        if (this.getExecType() == Types.ExecType.CP && this.inplace) {
            ret = InstructionUtils.concatOperands(ret, "InPlace");
        }
        return ret;
    }
}

