/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource.cost;

import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.resource.cost.VarStats;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class RDDStats {
    long distributedSize;
    int numPartitions;
    boolean hashPartitioned;
    boolean checkpoint;
    double cost;
    boolean isCollected;

    public RDDStats(VarStats sourceStats) {
        if (sourceStats == null) {
            throw new RuntimeException("RDDStats cannot be initialized without valid input variable statistics");
        }
        this.checkpoint = false;
        this.isCollected = false;
        this.hashPartitioned = false;
        this.distributedSize = RDDStats.estimateDistributedSize(sourceStats);
        this.numPartitions = this.getNumPartitions();
        this.cost = 0.0;
    }

    public RDDStats(long size, int partitions) {
        this.checkpoint = false;
        this.isCollected = false;
        this.hashPartitioned = false;
        this.distributedSize = size;
        this.numPartitions = partitions < 0 ? this.getNumPartitions() : partitions;
        this.cost = -1.0;
    }

    private int getNumPartitions() {
        if (this.distributedSize < 0L) {
            throw new RuntimeException("Estimating number of partitions requires valid distributed RDD size");
        }
        if (this.distributedSize > 0L) {
            long hdfsBlockSize = InfrastructureAnalyzer.getHDFSBlockSize();
            return (int)Math.max((this.distributedSize + hdfsBlockSize - 1L) / hdfsBlockSize, 1L);
        }
        return -1;
    }

    public double getCost() {
        return this.cost;
    }

    public boolean isCollected() {
        return this.isCollected;
    }

    private static long estimateDistributedSize(VarStats sourceStats) {
        if (sourceStats.isScalar()) {
            return 0L;
        }
        if (sourceStats.getCells() < 0L) {
            throw new RuntimeException("Estimated size for RDD object is negative");
        }
        return OptimizerUtils.estimatePartitionedSizeExactSparsity(sourceStats.getM(), sourceStats.getN(), (long)ConfigurationManager.getBlocksize(), sourceStats.getSparsity());
    }
}

