/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapURL;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.referral.AbstractFollowReferralHandler;
import org.ldaptive.referral.ReferralConnectionFactory;
import org.ldaptive.transport.DefaultSearchOperationHandle;

public abstract class AbstractFollowSearchReferralHandler
extends AbstractFollowReferralHandler<SearchRequest, SearchResponse> {
    public AbstractFollowSearchReferralHandler(int limit, int depth, ReferralConnectionFactory factory, boolean tf) {
        super(limit, depth, factory, tf);
    }

    @Override
    protected SearchRequest createReferralRequest(LdapURL url) {
        SearchRequest request = SearchRequest.copy((SearchRequest)this.getRequest());
        if (!url.getUrl().isDefaultScope()) {
            request.setSearchScope(url.getUrl().getScope());
        }
        if (!url.getUrl().isDefaultBaseDn()) {
            request.setBaseDn(url.getUrl().getBaseDn());
        }
        if (!url.getUrl().isDefaultFilter()) {
            request.setFilter(url.getUrl().getParsedFilter());
        }
        return request;
    }

    protected SearchOperation createReferralOperation(ConnectionFactory factory) {
        DefaultSearchOperationHandle handle = (DefaultSearchOperationHandle)this.getHandle();
        SearchOperation op = new SearchOperation(factory);
        op.setResultHandlers(handle.getOnResult());
        op.setControlHandlers(handle.getOnControl());
        op.setReferralHandlers(handle.getOnReferral());
        op.setIntermediateResponseHandlers(handle.getOnIntermediate());
        op.setExceptionHandler(handle.getOnException());
        op.setUnsolicitedNotificationHandlers(handle.getOnUnsolicitedNotification());
        op.setEntryHandlers(handle.getOnEntry());
        op.setReferenceHandlers(handle.getOnReference());
        op.setSearchResultHandlers(this.createNextSearchResultHandler());
        return op;
    }

    protected abstract SearchResultHandler[] createNextSearchResultHandler();
}

