/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.ldaptive.pool.AgePruneStrategy;
import org.ldaptive.pool.PooledConnectionProxy;

public class IdlePruneStrategy
extends AgePruneStrategy {
    private static final Duration DEFAULT_IDLE_TIME = Duration.ofMinutes(10L);
    private Duration idleTime;

    public IdlePruneStrategy() {
        this(DEFAULT_IDLE_TIME);
    }

    public IdlePruneStrategy(Duration idle) {
        this(idle.dividedBy(2L), idle);
    }

    public IdlePruneStrategy(Duration period, Duration idle) {
        this(period, idle, Duration.ZERO);
    }

    public IdlePruneStrategy(Duration period, Duration idle, Duration age) {
        this.setPrunePeriod(period);
        this.setIdleTime(idle);
        this.setAgeTime(age);
    }

    @Override
    public List<Predicate<PooledConnectionProxy>> getPruneConditions() {
        ArrayList<Predicate<PooledConnectionProxy>> predicates = new ArrayList<Predicate<PooledConnectionProxy>>(super.getPruneConditions());
        predicates.add(proxy -> {
            int totalSize = proxy.getConnectionPool().activeCount() + proxy.getConnectionPool().availableCount();
            int numConnAboveMin = totalSize - proxy.getMinPoolSize();
            int numConnToPrune = Math.min(proxy.getConnectionPool().availableCount(), numConnAboveMin);
            this.logger.trace("number of connections to prune {}", (Object)numConnToPrune);
            if (numConnToPrune > 0) {
                Instant timeAvailable = proxy.getPooledConnectionStatistics().getLastAvailableStat();
                this.logger.trace("evaluating time available {} for connection {}", (Object)timeAvailable, proxy);
                return timeAvailable == null || timeAvailable.plus(this.idleTime).isBefore(Instant.now());
            }
            return false;
        });
        return Collections.unmodifiableList(predicates);
    }

    @Override
    public int getStatisticsSize() {
        return 1;
    }

    public Duration getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(Duration time) {
        this.assertMutable();
        if (time == null || time.isNegative()) {
            throw new IllegalArgumentException("Idle time cannot be null or negative");
        }
        this.idleTime = time;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::prunePeriod=" + this.getPrunePeriod() + ", ageTime=" + this.getAgeTime() + ", prunePriority=" + this.getPrunePriority() + ", idleTime=" + this.idleTime + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AgePruneStrategy.Builder {
        protected Builder() {
            super(new IdlePruneStrategy());
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder idle(Duration time) {
            ((IdlePruneStrategy)this.object).setIdleTime(time);
            return this.self();
        }

        @Override
        public Builder period(Duration time) {
            ((AgePruneStrategy)this.object).setPrunePeriod(time);
            return this.self();
        }

        @Override
        public Builder age(Duration time) {
            ((AgePruneStrategy)this.object).setAgeTime(time);
            return this.self();
        }

        @Override
        public Builder priority(long l) {
            ((AgePruneStrategy)this.object).setPrunePriority(l);
            return this.self();
        }

        @Override
        public Builder priorityFactor(int i) {
            ((AgePruneStrategy)this.object).setPrunePriorityFactor(i);
            return this.self();
        }
    }
}

