/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import java.util.Arrays;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.dn.DefaultRDnNormalizer;
import org.ldaptive.dn.Dn;
import org.ldaptive.handler.AbstractEntryHandler;
import org.ldaptive.handler.LdapEntryHandler;

public class CaseChangeEntryHandler
extends AbstractEntryHandler
implements LdapEntryHandler {
    private static final int HASH_CODE_SEED = 821;
    private CaseChange dnCaseChange = CaseChange.NONE;
    private CaseChange attributeNameCaseChange = CaseChange.NONE;
    private CaseChange attributeValueCaseChange = CaseChange.NONE;
    private String[] attributeNames;

    public CaseChangeEntryHandler() {
    }

    public CaseChangeEntryHandler(CaseChange dnChange, CaseChange attrNameChange, CaseChange attrValueChange, String ... attrNames) {
        this.dnCaseChange = dnChange;
        this.attributeNameCaseChange = attrNameChange;
        this.attributeValueCaseChange = attrValueChange;
        this.attributeNames = attrNames;
    }

    public CaseChange getDnCaseChange() {
        return this.dnCaseChange;
    }

    public void setDnCaseChange(CaseChange cc) {
        this.assertMutable();
        this.dnCaseChange = cc;
    }

    public CaseChange getAttributeNameCaseChange() {
        return this.attributeNameCaseChange;
    }

    public void setAttributeNameCaseChange(CaseChange cc) {
        this.assertMutable();
        this.attributeNameCaseChange = cc;
    }

    public CaseChange getAttributeValueCaseChange() {
        return this.attributeValueCaseChange;
    }

    public void setAttributeValueCaseChange(CaseChange cc) {
        this.assertMutable();
        this.attributeValueCaseChange = cc;
    }

    public String[] getAttributeNames() {
        return LdapUtils.copyArray(this.attributeNames);
    }

    public void setAttributeNames(String ... names) {
        this.assertMutable();
        this.attributeNames = LdapUtils.copyArray(names);
    }

    @Override
    public LdapEntry apply(LdapEntry entry) {
        this.handleEntry(entry);
        return entry;
    }

    @Override
    protected String handleDn(LdapEntry entry) {
        Dn parsedDn;
        String dn = this.dnCaseChange == CaseChange.NONE ? entry.getDn() : ((parsedDn = entry.getParsedDn()) == null ? CaseChange.perform(this.dnCaseChange, entry.getDn()) : (this.dnCaseChange == CaseChange.LOWER ? parsedDn.format(new DefaultRDnNormalizer(s -> s, LdapUtils::toLowerCase, LdapUtils::toLowerCase, (nv1, nv2) -> 0)) : parsedDn.format(new DefaultRDnNormalizer(s -> s, LdapUtils::toUpperCase, LdapUtils::toUpperCase, (nv1, nv2) -> 0))));
        return dn;
    }

    @Override
    protected void handleAttributes(LdapEntry entry) {
        if (this.attributeNames == null) {
            super.handleAttributes(entry);
        } else {
            for (String s : this.attributeNames) {
                LdapAttribute la = entry.getAttribute(s);
                if (la == null) continue;
                this.handleAttribute(la);
            }
        }
    }

    @Override
    protected String handleAttributeName(String name) {
        return CaseChange.perform(this.attributeNameCaseChange, name);
    }

    @Override
    protected String handleAttributeValue(String value) {
        return CaseChange.perform(this.attributeValueCaseChange, value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CaseChangeEntryHandler) {
            CaseChangeEntryHandler v = (CaseChangeEntryHandler)o;
            return LdapUtils.areEqual((Object)this.dnCaseChange, (Object)v.dnCaseChange) && LdapUtils.areEqual((Object)this.attributeNameCaseChange, (Object)v.attributeNameCaseChange) && LdapUtils.areEqual((Object)this.attributeValueCaseChange, (Object)v.attributeValueCaseChange) && LdapUtils.areEqual(this.attributeNames, v.attributeNames);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(821, new Object[]{this.dnCaseChange, this.attributeNameCaseChange, this.attributeValueCaseChange, this.attributeNames});
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::dnCaseChange=" + this.dnCaseChange + ", attributeNameCaseChange=" + this.attributeNameCaseChange + ", attributeValueCaseChange=" + this.attributeValueCaseChange + ", attributeNames=" + Arrays.toString(this.attributeNames) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final CaseChangeEntryHandler object = new CaseChangeEntryHandler();

        private Builder() {
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder dnCaseChange(CaseChange cc) {
            this.object.setDnCaseChange(cc);
            return this;
        }

        public Builder attributeNameCaseChange(CaseChange cc) {
            this.object.setAttributeNameCaseChange(cc);
            return this;
        }

        public Builder attributeValueCaseChange(CaseChange cc) {
            this.object.setAttributeValueCaseChange(cc);
            return this;
        }

        public Builder attributeNames(String ... names) {
            this.object.setAttributeNames(names);
            return this;
        }

        public CaseChangeEntryHandler build() {
            return this.object;
        }
    }

    public static enum CaseChange {
        NONE,
        LOWER,
        UPPER;


        public static String perform(CaseChange cc, String string) {
            String s = null;
            if (LOWER == cc) {
                s = LdapUtils.toLowerCase(string);
            } else if (UPPER == cc) {
                s = LdapUtils.toUpperCase(string);
            } else if (NONE == cc) {
                s = string;
            }
            return s;
        }
    }
}

