/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.state.internals.AbstractSegments;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;

class KeyValueSegments
extends AbstractSegments<KeyValueSegment> {
    private final RocksDBMetricsRecorder metricsRecorder;

    KeyValueSegments(String name, String metricsScope, long retentionPeriod, long segmentInterval) {
        super(name, retentionPeriod, segmentInterval);
        this.metricsRecorder = new RocksDBMetricsRecorder(metricsScope, name);
    }

    @Override
    public KeyValueSegment getOrCreateSegment(long segmentId, ProcessorContext context) {
        if (this.segments.containsKey(segmentId)) {
            return (KeyValueSegment)this.segments.get(segmentId);
        }
        KeyValueSegment newSegment = new KeyValueSegment(this.segmentName(segmentId), this.name, segmentId, this.position, this.metricsRecorder);
        if (this.segments.put(segmentId, newSegment) != null) {
            throw new IllegalStateException("KeyValueSegment already exists. Possible concurrent access.");
        }
        newSegment.openDB(context.appConfigs(), context.stateDir());
        return newSegment;
    }

    @Override
    public KeyValueSegment getOrCreateSegmentIfLive(long segmentId, ProcessorContext context, long streamTime) {
        KeyValueSegment segment = (KeyValueSegment)super.getOrCreateSegmentIfLive(segmentId, context, streamTime);
        this.cleanupExpiredSegments(streamTime);
        return segment;
    }

    @Override
    public void openExisting(ProcessorContext context, long streamTime) {
        this.metricsRecorder.init(ProcessorContextUtils.getMetricsImpl(context), context.taskId());
        super.openExisting(context, streamTime);
    }
}

