/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceNamingStrategy;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.actions.composite.MultifactorProviderSelectionCriteria;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationTrustProviderSelectionCriteria
implements MultifactorProviderSelectionCriteria {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationTrustProviderSelectionCriteria.class);
    protected final ServicesManager servicesManager;
    protected final MultifactorAuthenticationTrustStorage mfaTrustEngine;
    protected final MultifactorAuthenticationTrustedDeviceNamingStrategy mfaTrustDeviceNamingStrategy;
    protected final DeviceFingerprintStrategy deviceFingerprintStrategy;
    protected final CasCookieBuilder deviceFingerprintCookieGenerator;
    protected final CasConfigurationProperties casProperties;

    public boolean shouldProceedWithMultifactorProviderSelection(RequestContext requestContext) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        String principal = authentication.getPrincipal().getId();
        LOGGER.trace("Retrieving trusted authentication records for [{}]", (Object)principal);
        Set<? extends MultifactorAuthenticationTrustRecord> results = this.mfaTrustEngine.get(principal);
        String fingerprint = this.deviceFingerprintStrategy.determineFingerprint(authentication, request, response);
        LOGGER.trace("Checking trusted authentication records for [{}] that matches [{}]", (Object)principal, (Object)fingerprint);
        List<MultifactorAuthenticationTrustRecord> trustedDevices = results.stream().filter(entry -> entry.getDeviceFingerprint().equals(fingerprint)).toList();
        if (trustedDevices.isEmpty()) {
            LOGGER.debug("No trusted authentication records could be found for [{}] to match the current device fingerprint", (Object)principal);
            return true;
        }
        MultifactorAuthenticationProvider provider = (MultifactorAuthenticationProvider)requestContext.getCurrentEvent().getAttributes().get(MultifactorAuthenticationProvider.class.getName(), MultifactorAuthenticationProvider.class);
        Optional<MultifactorAuthenticationTrustRecord> matchingDevice = trustedDevices.stream().filter(device -> StringUtils.isNotBlank((CharSequence)device.getMultifactorAuthenticationProvider())).filter(device -> provider.matches(device.getMultifactorAuthenticationProvider())).findFirst();
        if (matchingDevice.isPresent()) {
            Optional mfaProvider = MultifactorAuthenticationUtils.getMultifactorAuthenticationProviderById((String)matchingDevice.get().getMultifactorAuthenticationProvider(), (ApplicationContext)requestContext.getActiveFlow().getApplicationContext());
            requestContext.getFlashScope().put("mfaProvider", mfaProvider.orElseThrow());
            return false;
        }
        return true;
    }

    @Generated
    public MultifactorAuthenticationTrustProviderSelectionCriteria(ServicesManager servicesManager, MultifactorAuthenticationTrustStorage mfaTrustEngine, MultifactorAuthenticationTrustedDeviceNamingStrategy mfaTrustDeviceNamingStrategy, DeviceFingerprintStrategy deviceFingerprintStrategy, CasCookieBuilder deviceFingerprintCookieGenerator, CasConfigurationProperties casProperties) {
        this.servicesManager = servicesManager;
        this.mfaTrustEngine = mfaTrustEngine;
        this.mfaTrustDeviceNamingStrategy = mfaTrustDeviceNamingStrategy;
        this.deviceFingerprintStrategy = deviceFingerprintStrategy;
        this.deviceFingerprintCookieGenerator = deviceFingerprintCookieGenerator;
        this.casProperties = casProperties;
    }
}

