/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.toolbar;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NavigatorLabel;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.model.IModel;
import org.wicketstuff.egrid.component.EditableDataTable;
import org.wicketstuff.egrid.toolbar.AbstractEditableToolbar;

public class NavigationToolbar
extends AbstractEditableToolbar {
    private static final long serialVersionUID = 1L;

    public NavigationToolbar(EditableDataTable<?, ?> table) {
        super(table);
        WebMarkupContainer span = new WebMarkupContainer("span");
        this.add(new Component[]{span});
        span.add(new Behavior[]{AttributeModifier.replace((String)"colspan", (IModel & Serializable)() -> String.valueOf(table.getColumns().size()).intern())});
        span.add(new Component[]{this.newPagingNavigator("navigator", table)});
        span.add(new Component[]{this.newNavigatorLabel("navigatorLabel", table)});
    }

    protected PagingNavigator newPagingNavigator(String navigatorId, EditableDataTable<?, ?> table) {
        return new AjaxPagingNavigator(navigatorId, (IPageable)table){

            protected void onAjaxEvent(AjaxRequestTarget target) {
                target.add(new Component[]{NavigationToolbar.this.getTable()});
            }
        };
    }

    protected WebComponent newNavigatorLabel(String navigatorId, EditableDataTable<?, ?> table) {
        return new NavigatorLabel(navigatorId, table);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setVisible(this.getTable().getPageCount() > 1L);
    }
}

