/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.Collection;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkMoveDeadLetterJobsToHistoryJobsCmd
implements Command<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkMoveDeadLetterJobsToHistoryJobsCmd.class);
    protected JobServiceConfiguration jobServiceConfiguration;
    protected Collection<String> deadLetterJobIds;
    protected int retries;

    public BulkMoveDeadLetterJobsToHistoryJobsCmd(Collection<String> deadLetterJobIds, int retries, JobServiceConfiguration jobServiceConfiguration) {
        this.deadLetterJobIds = deadLetterJobIds;
        this.retries = retries;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        if (this.deadLetterJobIds == null) {
            throw new FlowableIllegalArgumentException("deadLetterJobIds are null");
        }
        DeadLetterJobQueryImpl query = new DeadLetterJobQueryImpl(commandContext, this.jobServiceConfiguration);
        query.jobIds(this.deadLetterJobIds);
        List<Job> deadLetterJobs = this.jobServiceConfiguration.getDeadLetterJobEntityManager().findJobsByQueryCriteria(query);
        for (Job job : deadLetterJobs) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Moving deadletter job to history job table {}", (Object)job.getId());
            }
            this.jobServiceConfiguration.getJobManager().moveDeadLetterJobToHistoryJob((DeadLetterJobEntity)job, this.retries);
        }
        return null;
    }
}

