/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;

public class CallActivityJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        CallActivityJsonConverter.fillJsonTypes(convertersToBpmnMap);
        CallActivityJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CallActivity", CallActivityJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(CallActivity.class, CallActivityJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "CallActivity";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        CallActivity callActivity = (CallActivity)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            propertiesNode.put("callactivitycalledelement", callActivity.getCalledElement());
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElementType())) {
            propertiesNode.put("callactivitycalledelementtype", callActivity.getCalledElementType());
        }
        if (callActivity.isInheritVariables()) {
            propertiesNode.put("callactivityinheritvariables", callActivity.isInheritVariables());
        }
        if (callActivity.isSameDeployment()) {
            propertiesNode.put("callactivitysamedeployment", callActivity.isSameDeployment());
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getProcessInstanceName())) {
            propertiesNode.put("callactivityprocessinstancename", callActivity.getProcessInstanceName());
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getBusinessKey())) {
            propertiesNode.put("callactivitybusinesskey", callActivity.getBusinessKey());
        }
        if (callActivity.isInheritBusinessKey()) {
            propertiesNode.put("callactivityinheritbusinesskey", callActivity.isInheritBusinessKey());
        }
        if (callActivity.isUseLocalScopeForOutParameters()) {
            propertiesNode.put("callactivityuselocalscopeforoutparameters", callActivity.isUseLocalScopeForOutParameters());
        }
        if (callActivity.isCompleteAsync()) {
            propertiesNode.put("callactivitycompleteasync", callActivity.isCompleteAsync());
        }
        if (callActivity.getFallbackToDefaultTenant() != null) {
            propertiesNode.put("callactivityfallbacktodefaulttenant", callActivity.getFallbackToDefaultTenant());
        }
        if (callActivity.getProcessInstanceIdVariableName() != null) {
            propertiesNode.put("callactivityidvariablename", callActivity.getProcessInstanceIdVariableName());
        }
        CallActivityJsonConverter.addJsonParameters("callactivityinparameters", "inParameters", callActivity.getInParameters(), propertiesNode);
        CallActivityJsonConverter.addJsonParameters("callactivityoutparameters", "outParameters", callActivity.getOutParameters(), propertiesNode);
    }

    private static void addJsonParameters(String propertyName, String valueName, List<IOParameter> parameterList, ObjectNode propertiesNode) {
        ObjectNode parametersNode = JSON_MAPPER.createObjectNode();
        ArrayNode itemsNode = JSON_MAPPER.createArrayNode();
        for (IOParameter parameter : parameterList) {
            ObjectNode parameterItemNode = JSON_MAPPER.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSource())) {
                parameterItemNode.put("source", parameter.getSource());
            } else {
                parameterItemNode.putNull("source");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getTarget())) {
                parameterItemNode.put("target", parameter.getTarget());
            } else {
                parameterItemNode.putNull("target");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression())) {
                parameterItemNode.put("sourceExpression", parameter.getSourceExpression());
            } else {
                parameterItemNode.putNull("sourceExpression");
            }
            itemsNode.add((JsonNode)parameterItemNode);
        }
        parametersNode.set(valueName, (JsonNode)itemsNode);
        propertiesNode.set(propertyName, (JsonNode)parametersNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        String idVariableName;
        String businessKey;
        String processInstanceName;
        CallActivity callActivity = new CallActivity();
        if (StringUtils.isNotEmpty((CharSequence)JsonConverterUtil.getPropertyValueAsString("callactivitycalledelement", elementNode))) {
            callActivity.setCalledElement(JsonConverterUtil.getPropertyValueAsString("callactivitycalledelement", elementNode));
        }
        if (StringUtils.isNotEmpty((CharSequence)JsonConverterUtil.getPropertyValueAsString("callactivitycalledelementtype", elementNode))) {
            callActivity.setCalledElementType(JsonConverterUtil.getPropertyValueAsString("callactivitycalledelementtype", elementNode));
        }
        if (JsonConverterUtil.getPropertyValueAsBoolean("callactivityinheritvariables", elementNode)) {
            callActivity.setInheritVariables(true);
        }
        if (JsonConverterUtil.getPropertyValueAsBoolean("callactivitysamedeployment", elementNode)) {
            callActivity.setSameDeployment(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)(processInstanceName = JsonConverterUtil.getPropertyValueAsString("callactivityprocessinstancename", elementNode)))) {
            callActivity.setProcessInstanceName(processInstanceName);
        }
        if (StringUtils.isNotEmpty((CharSequence)(businessKey = JsonConverterUtil.getPropertyValueAsString("callactivitybusinesskey", elementNode)))) {
            callActivity.setBusinessKey(businessKey);
        }
        if (JsonConverterUtil.getPropertyValueAsBoolean("callactivityinheritbusinesskey", elementNode)) {
            callActivity.setInheritBusinessKey(true);
        }
        if (JsonConverterUtil.getPropertyValueAsBoolean("callactivityuselocalscopeforoutparameters", elementNode)) {
            callActivity.setUseLocalScopeForOutParameters(true);
        }
        if (JsonConverterUtil.getPropertyValueAsBoolean("callactivitycompleteasync", elementNode)) {
            callActivity.setCompleteAsync(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)JsonConverterUtil.getPropertyValueAsString("callactivityfallbacktodefaulttenant", elementNode))) {
            callActivity.setFallbackToDefaultTenant(Boolean.valueOf(JsonConverterUtil.getPropertyValueAsBoolean("callactivityfallbacktodefaulttenant", elementNode)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(idVariableName = JsonConverterUtil.getPropertyValueAsString("callactivityidvariablename", elementNode)))) {
            callActivity.setProcessInstanceIdVariableName(idVariableName);
        }
        callActivity.getInParameters().addAll(CallActivityJsonConverter.convertToIOParameters("callactivityinparameters", "inParameters", elementNode));
        callActivity.getOutParameters().addAll(CallActivityJsonConverter.convertToIOParameters("callactivityoutparameters", "outParameters", elementNode));
        return callActivity;
    }

    private static List<IOParameter> convertToIOParameters(String propertyName, String valueName, JsonNode elementNode) {
        JsonNode parametersNode = JsonConverterUtil.getProperty(propertyName, elementNode);
        if (parametersNode == null) {
            return List.of();
        }
        JsonNode itemsArrayNode = (parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)).get(valueName);
        if (itemsArrayNode == null) {
            return List.of();
        }
        ArrayList<IOParameter> ioParameters = new ArrayList<IOParameter>();
        for (JsonNode itemNode : itemsArrayNode) {
            JsonNode sourceNode = itemNode.get("source");
            JsonNode sourceExpressionNode = itemNode.get("sourceExpression");
            if ((sourceNode == null || !StringUtils.isNotEmpty((CharSequence)sourceNode.asText())) && (sourceExpressionNode == null || !StringUtils.isNotEmpty((CharSequence)sourceExpressionNode.asText()))) continue;
            IOParameter parameter = new IOParameter();
            if (StringUtils.isNotEmpty((CharSequence)CallActivityJsonConverter.getValueAsString("source", itemNode))) {
                parameter.setSource(CallActivityJsonConverter.getValueAsString("source", itemNode));
            } else if (StringUtils.isNotEmpty((CharSequence)CallActivityJsonConverter.getValueAsString("sourceExpression", itemNode))) {
                parameter.setSourceExpression(CallActivityJsonConverter.getValueAsString("sourceExpression", itemNode));
            }
            if (StringUtils.isNotEmpty((CharSequence)CallActivityJsonConverter.getValueAsString("target", itemNode))) {
                parameter.setTarget(CallActivityJsonConverter.getValueAsString("target", itemNode));
            }
            ioParameters.add(parameter);
        }
        return ioParameters;
    }
}

