/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.RegisteredServiceAwareAuthenticationTransaction;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;

public class DefaultAuthenticationTransaction
implements RegisteredServiceAwareAuthenticationTransaction {
    private static final long serialVersionUID = 6213904009424725484L;
    private final Service service;
    private final RegisteredService registeredService;
    private final Collection<Credential> credentials;
    private final Collection<Authentication> authentications = new ArrayList<Authentication>();

    @CanIgnoreReturnValue
    public AuthenticationTransaction collect(Collection<Authentication> authentications) {
        this.authentications.addAll(authentications);
        return this;
    }

    public Optional<Credential> getPrimaryCredential() {
        return Objects.requireNonNull(this.credentials).stream().findFirst();
    }

    public boolean hasCredentialOfType(Class<? extends Credential> type) {
        return Objects.requireNonNull(this.credentials).stream().anyMatch(type::isInstance);
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public RegisteredService getRegisteredService() {
        return this.registeredService;
    }

    @Generated
    public Collection<Credential> getCredentials() {
        return this.credentials;
    }

    @Generated
    public Collection<Authentication> getAuthentications() {
        return this.authentications;
    }

    @Generated
    public DefaultAuthenticationTransaction(Service service, RegisteredService registeredService, Collection<Credential> credentials) {
        this.service = service;
        this.registeredService = registeredService;
        this.credentials = credentials;
    }

    @Generated
    public String toString() {
        return "DefaultAuthenticationTransaction(service=" + String.valueOf(this.service) + ", registeredService=" + String.valueOf(this.registeredService) + ", credentials=" + String.valueOf(this.credentials) + ", authentications=" + String.valueOf(this.authentications) + ")";
    }

    @Generated
    private DefaultAuthenticationTransaction() {
        this.service = null;
        this.registeredService = null;
        this.credentials = null;
    }
}

